/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import java.io.File;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.logback.FileLoggerSettings;
import org.apache.qpid.server.logging.logback.RollingPolicyDecorator;

public class AppenderUtils {
    public static void configureRollingFileAppender(FileLoggerSettings fileLoggerSettings, Context loggerContext, RollingFileAppender<ILoggingEvent> appender) {
        Object triggeringPolicy;
        SimpleRollingPolicy rollingPolicy;
        String fileName = fileLoggerSettings.getFileName();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        AppenderUtils.validateLogFilePermissions(file);
        AppenderUtils.validateMaxFileSize(fileLoggerSettings.getMaxFileSize());
        appender.setFile(fileName);
        appender.setAppend(true);
        appender.setContext(loggerContext);
        String maxFileSizeAsString = String.valueOf(fileLoggerSettings.getMaxFileSize()) + "MB";
        if (fileLoggerSettings.isRollDaily()) {
            DailyTriggeringPolicy dailyTriggeringPolicy = new DailyTriggeringPolicy(fileLoggerSettings.isRollOnRestart(), maxFileSizeAsString);
            dailyTriggeringPolicy.setContext(loggerContext);
            TimeBasedRollingPolicy timeBasedRollingPolicy = new TimeBasedRollingPolicy();
            timeBasedRollingPolicy.setMaxHistory(fileLoggerSettings.getMaxHistory());
            timeBasedRollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)dailyTriggeringPolicy);
            timeBasedRollingPolicy.setFileNamePattern(fileName + ".%d{yyyy-MM-dd}.%i" + (fileLoggerSettings.isCompressOldFiles() ? ".gz" : ""));
            rollingPolicy = timeBasedRollingPolicy;
            triggeringPolicy = dailyTriggeringPolicy;
        } else {
            SizeTriggeringPolicy sizeTriggeringPolicy = new SizeTriggeringPolicy(fileLoggerSettings.isRollOnRestart(), maxFileSizeAsString);
            sizeTriggeringPolicy.setContext(loggerContext);
            SimpleRollingPolicy simpleRollingPolicy = new SimpleRollingPolicy(fileLoggerSettings.getMaxHistory());
            simpleRollingPolicy.setFileNamePattern(fileName + ".%i" + (fileLoggerSettings.isCompressOldFiles() ? ".gz" : ""));
            rollingPolicy = simpleRollingPolicy;
            triggeringPolicy = sizeTriggeringPolicy;
        }
        rollingPolicy.setContext(loggerContext);
        RollingPolicyDecorator decorator = new RollingPolicyDecorator((RollingPolicyBase)rollingPolicy, fileLoggerSettings.getRolloverListener(), fileLoggerSettings.getExecutorService());
        decorator.setParent((FileAppender)appender);
        appender.setRollingPolicy((RollingPolicy)decorator);
        appender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
        decorator.start();
        triggeringPolicy.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(fileLoggerSettings.getLayout());
        encoder.setContext(loggerContext);
        encoder.start();
        appender.setEncoder((Encoder)encoder);
    }

    static void validateLogFilePermissions(File file) {
        if (file.exists() && (!file.isFile() || !file.canWrite()) || !file.getAbsoluteFile().getParentFile().canWrite()) {
            throw new IllegalConfigurationException(String.format("Do not have the permissions to log to file '%s'.", file.getAbsolutePath()));
        }
    }

    static void validateMaxFileSize(int maxFileSize) {
        if (maxFileSize < 1) {
            throw new IllegalConfigurationException(String.format("Maximum file size must be at least 1. Cannot set to %d.", maxFileSize));
        }
    }

    static class SimpleRollingPolicy
    extends FixedWindowRollingPolicy {
        private int _maxFiles;

        public SimpleRollingPolicy(int maxHistory) {
            this._maxFiles = maxHistory;
            this.setMaxIndex(maxHistory);
            this.setMinIndex(1);
        }

        protected int getMaxWindowSize() {
            return this._maxFiles;
        }
    }

    static class SizeTriggeringPolicy
    extends SizeBasedTriggeringPolicy<ILoggingEvent> {
        private final boolean _rollOnRestart;
        private boolean _isFirst = true;

        public SizeTriggeringPolicy(boolean isRollOnRestart, String maxFileSize) {
            this._rollOnRestart = isRollOnRestart;
            this.setMaxFileSize(maxFileSize);
        }

        public boolean isTriggeringEvent(File activeFile, ILoggingEvent event) {
            if (this._rollOnRestart && this._isFirst) {
                this._isFirst = false;
                return activeFile.exists() && activeFile.length() != 0L;
            }
            return super.isTriggeringEvent(activeFile, (Object)event);
        }
    }

    static class DailyTriggeringPolicy
    extends SizeAndTimeBasedFNATP<ILoggingEvent> {
        private final boolean _rollOnRestart;
        private boolean _isFirst = true;

        public DailyTriggeringPolicy(boolean isRollOnRestart, String maxFileSize) {
            this._rollOnRestart = isRollOnRestart;
            this.setMaxFileSize(maxFileSize);
        }

        protected void computeNextCheck() {
            super.computeNextCheck();
            if (this._rollOnRestart && this._isFirst) {
                this._isFirst = false;
                this.nextCheck = 0L;
            }
        }

        public boolean isTriggeringEvent(File activeFile, ILoggingEvent event) {
            if (this._rollOnRestart && this._isFirst) {
                this._isFirst = false;
                return activeFile.exists() && activeFile.length() != 0L;
            }
            return super.isTriggeringEvent(activeFile, (Object)event);
        }
    }
}

