/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import java.util.List;
import java.util.Set;
import org.apache.qpid.server.logging.LogFileDetails;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.Param;

@ManagedObject(category=false, type="File", validChildTypes="org.apache.qpid.server.logging.logback.AbstractLogger#getSupportedBrokerLoggerChildTypes()")
public interface BrokerFileLogger<X extends BrokerFileLogger<X>>
extends BrokerLogger<X> {
    public static final String TYPE = "File";
    public static final String FILE_NAME = "fileName";
    public static final String MAX_FILE_SIZE = "maxFileSize";
    public static final String BROKER_FAIL_ON_LOGGER_IO_ERROR = "broker.failOnLoggerIOError";
    @ManagedContextDefault(name="broker.failOnLoggerIOError")
    public static final String DEFAULT_BROKER_FAIL_ON_LOGGER_IO_ERROR = "false";

    @ManagedAttribute(defaultValue="${qpid.work_dir}${file.separator}log${file.separator}qpid.log")
    public String getFileName();

    @ManagedAttribute(defaultValue="false")
    public boolean isRollDaily();

    @ManagedAttribute(defaultValue="false")
    public boolean isRollOnRestart();

    @ManagedAttribute(defaultValue="false")
    public boolean isCompressOldFiles();

    @ManagedAttribute(defaultValue="1")
    public int getMaxHistory();

    @ManagedAttribute(defaultValue="100")
    public int getMaxFileSize();

    @ManagedAttribute(defaultValue="%date %-5level [%thread] \\(%logger{2}\\) - %msg%n")
    public String getLayout();

    @DerivedAttribute
    public List<LogFileDetails> getLogFiles();

    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false)
    public Content getFile(@Param(name="fileName") String var1);

    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false)
    public Content getFiles(@Param(name="fileName") Set<String> var1);

    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false)
    public Content getAllFiles();
}

