/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQShortString
implements Comparable<AMQShortString> {
    public static final int MAX_LENGTH = 255;
    private static final byte MINUS = 45;
    private static final byte ZERO = 48;
    private static final Logger _logger = LoggerFactory.getLogger(AMQShortString.class);
    private final byte[] _data;
    private final int _offset;
    private int _hashCode;
    private String _asString = null;
    private final int _length;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final AMQShortString EMPTY_STRING = new AMQShortString((String)null);

    public AMQShortString(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Cannot create AMQShortString with null data[]");
        }
        if (data.length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        this._data = (byte[])data.clone();
        this._length = data.length;
        this._offset = 0;
    }

    public AMQShortString(String string) {
        byte[] data = EncodingUtils.asUTF8Bytes(string);
        int length = data.length;
        if (data.length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)(0xFF & data[i]);
            hash = 31 * hash + data[i];
        }
        this._hashCode = hash;
        this._data = data;
        this._length = length;
        this._offset = 0;
        this._asString = string == null ? "" : string;
    }

    public static AMQShortString readAMQShortString(ByteBuffer buffer) {
        int length = buffer.get() & 0xFF;
        if (length == 0) {
            return null;
        }
        if (length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        if (length > buffer.remaining()) {
            throw new IllegalArgumentException("Cannot create AMQShortString with length " + length + " from a ByteBuffer with only " + buffer.remaining() + " bytes.");
        }
        byte[] data = new byte[length];
        buffer.get(data);
        return new AMQShortString(data, 0, length);
    }

    public static AMQShortString readAMQShortString(QpidByteBuffer buffer) {
        int length = buffer.get() & 0xFF;
        if (length == 0) {
            return null;
        }
        if (length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        if (length > buffer.remaining()) {
            throw new IllegalArgumentException("Cannot create AMQShortString with length " + length + " from a ByteBuffer with only " + buffer.remaining() + " bytes.");
        }
        byte[] data = new byte[length];
        buffer.get(data);
        return new AMQShortString(data, 0, length);
    }

    public AMQShortString(byte[] data, int offset, int length) {
        if (length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        if (data == null) {
            throw new NullPointerException("Cannot create AMQShortString with null data[]");
        }
        this._offset = offset;
        this._length = length;
        this._data = data;
    }

    public int length() {
        return this._length;
    }

    public char charAt(int index) {
        return (char)this._data[this._offset + index];
    }

    public byte[] getBytes() {
        if (this._offset == 0 && this._length == this._data.length) {
            return (byte[])this._data.clone();
        }
        byte[] data = new byte[this._length];
        System.arraycopy(this._data, this._offset, data, 0, this._length);
        return data;
    }

    public void writeToBuffer(QpidByteBuffer buffer) {
        int size = this.length();
        buffer.put((byte)size);
        buffer.put(this._data, this._offset, size);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AMQShortString) {
            return this.equals((AMQShortString)o);
        }
        return false;
    }

    public boolean equals(AMQShortString otherString) {
        if (otherString == this) {
            return true;
        }
        if (otherString == null) {
            return false;
        }
        int hashCode = this._hashCode;
        int otherHashCode = otherString._hashCode;
        if (hashCode != 0 && otherHashCode != 0 && hashCode != otherHashCode) {
            return false;
        }
        int length = this._length;
        if (length != otherString._length) {
            return false;
        }
        byte[] data = this._data;
        byte[] otherData = otherString._data;
        int offset = this._offset;
        int otherOffset = otherString._offset;
        if (offset == 0 && otherOffset == 0 && length == data.length && length == otherData.length) {
            return Arrays.equals(data, otherData);
        }
        int thisIdx = offset;
        int otherIdx = otherOffset;
        int i = length;
        while (i-- != 0) {
            if (data[thisIdx++] == otherData[otherIdx++]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this._hashCode;
        if (hash == 0) {
            int size = this.length();
            for (int i = 0; i < size; ++i) {
                hash = 31 * hash + this._data[i + this._offset];
            }
            this._hashCode = hash;
        }
        return hash;
    }

    public String toString() {
        if (this._asString == null) {
            this._asString = new String(this._data, this._offset, this._length, StandardCharsets.UTF_8);
        }
        return this._asString;
    }

    @Override
    public int compareTo(AMQShortString name) {
        if (name == this) {
            return 0;
        }
        if (name == null) {
            return 1;
        }
        if (name.length() < this.length()) {
            return -name.compareTo(this);
        }
        for (int i = 0; i < this.length(); ++i) {
            byte d = this._data[i + this._offset];
            byte n = name._data[i + name._offset];
            if (d < n) {
                return -1;
            }
            if (d <= n) continue;
            return 1;
        }
        return this.length() == name.length() ? 0 : -1;
    }

    public int toIntValue() {
        boolean isNegative;
        int pos = this._offset;
        int val = 0;
        boolean bl = isNegative = this._data[pos] == 45;
        if (isNegative) {
            ++pos;
        }
        int end = this._length + this._offset;
        while (pos < end) {
            int digit;
            if ((digit = this._data[pos++] - 48) < 0 || digit > 9) {
                throw new NumberFormatException("\"" + this.toString() + "\" is not a valid number");
            }
            val *= 10;
            val += digit;
        }
        if (isNegative) {
            val *= -1;
        }
        return val;
    }

    public boolean contains(byte b) {
        int end = this._length + this._offset;
        for (int i = this._offset; i < end; ++i) {
            if (this._data[i] != b) continue;
            return true;
        }
        return false;
    }

    public static AMQShortString validValueOf(Object obj) {
        return AMQShortString.valueOf(obj, true, true);
    }

    static AMQShortString valueOf(Object obj, boolean truncate, boolean nullAsEmptyString) {
        if (obj == null) {
            if (nullAsEmptyString) {
                return EMPTY_STRING;
            }
            return null;
        }
        String value = String.valueOf(obj);
        int strLength = Math.min(value.length(), 255);
        byte[] bytes = EncodingUtils.asUTF8Bytes(value);
        if (truncate) {
            while (bytes.length > 255) {
                value = value.substring(0, strLength-- - 3) + "...";
                bytes = EncodingUtils.asUTF8Bytes(value);
            }
        }
        return new AMQShortString(bytes);
    }

    public static AMQShortString valueOf(Object obj) {
        return AMQShortString.valueOf(obj, false, false);
    }

    public static AMQShortString valueOf(String obj) {
        if (obj == null) {
            return null;
        }
        return new AMQShortString(obj);
    }

    public static String toString(AMQShortString amqShortString) {
        return amqShortString == null ? null : amqShortString.toString();
    }
}

