/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.MethodProcessor;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.transport.ByteBufferSender;

public class HeartbeatBody
implements AMQBody {
    public static final byte TYPE = 8;
    public static final AMQFrame FRAME = new HeartbeatBody().toFrame();

    public HeartbeatBody() {
    }

    public HeartbeatBody(DataInputStream buffer, long size) throws IOException {
        if (size > 0L) {
            buffer.skip(size);
        }
    }

    @Override
    public byte getFrameType() {
        return 8;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public long writePayload(ByteBufferSender sender) {
        return 0L;
    }

    @Override
    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws QpidException {
        session.heartbeatBodyReceived(channelId, this);
    }

    protected void populateFromBuffer(DataInputStream buffer, long size) throws AMQFrameDecodingException, IOException {
        if (size > 0L) {
            buffer.skip(size);
        }
    }

    public AMQFrame toFrame() {
        return new AMQFrame(0, this);
    }

    public static void process(int channel, QpidByteBuffer in, MethodProcessor processor, long bodySize) {
        if (bodySize > 0L) {
            in.position(in.position() + (int)bodySize);
        }
        processor.receiveHeartbeat();
    }
}

