/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.qpid.transport.network.security.ssl.QpidClientX509KeyManager;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;

public class SSLContextFactory {
    private SSLContextFactory() {
    }

    public static SSLContext buildClientContext(TrustManager[] trustManagers, KeyManager[] keyManagers) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLUtil.tryGetSSLContext();
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    public static KeyManager[] getKeyManagers(String keyStorePath, String keyStorePassword, String keyStoreType, String keyManagerFactoryAlgorithm, String certAlias) throws GeneralSecurityException, IOException {
        KeyManager[] keyManagers;
        if (keyStorePath != null) {
            if (certAlias != null) {
                keyManagers = new KeyManager[]{new QpidClientX509KeyManager(certAlias, keyStorePath, keyStoreType, keyStorePassword, keyManagerFactoryAlgorithm)};
            } else {
                KeyStore ks = SSLUtil.getInitializedKeyStore(keyStorePath, keyStorePassword, keyStoreType);
                char[] keyStoreCharPassword = keyStorePassword == null ? null : keyStorePassword.toCharArray();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm);
                kmf.init(ks, keyStoreCharPassword);
                keyManagers = kmf.getKeyManagers();
            }
        } else {
            keyManagers = null;
        }
        return keyManagers;
    }

    public static TrustManager[] getTrustManagers(String trustStorePath, String trustStorePassword, String trustStoreType, String trustManagerFactoryAlgorithm) throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers;
        if (trustStorePath != null) {
            KeyStore ts = SSLUtil.getInitializedKeyStore(trustStorePath, trustStorePassword, trustStoreType);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
            tmf.init(ts);
            trustManagers = tmf.getTrustManagers();
        } else {
            trustManagers = null;
        }
        return trustManagers;
    }
}

