/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.qpid.util.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZIPUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GZIPUtils.class);
    public static final String GZIP_CONTENT_ENCODING = "gzip";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compressBufferToArray(ByteBuffer input) {
        if (input == null) return null;
        try (ByteArrayOutputStream compressedBuffer = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(compressedBuffer);){
                if (input.hasArray()) {
                    gzipOutputStream.write(input.array(), input.arrayOffset() + input.position(), input.remaining());
                } else {
                    byte[] data = new byte[input.remaining()];
                    input.duplicate().get(data);
                    gzipOutputStream.write(data);
                }
            }
            byte[] byArray = compressedBuffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LOGGER.warn("Unexpected IOException when attempting to compress with gzip", (Throwable)e);
        }
        return null;
    }

    public static byte[] uncompressBufferToArray(ByteBuffer contentBuffer) {
        if (contentBuffer != null) {
            try (ByteBufferInputStream input = new ByteBufferInputStream(contentBuffer);){
                byte[] byArray = GZIPUtils.uncompressStreamToArray(input);
                return byArray;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] uncompressStreamToArray(InputStream stream) {
        if (stream == null) return null;
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(stream);){
            int read;
            ByteArrayOutputStream inflatedContent = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((read = gzipInputStream.read(buf)) != -1) {
                inflatedContent.write(buf, 0, read);
            }
            byte[] byArray = inflatedContent.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LOGGER.warn("Unexpected IOException when attempting to uncompress with gzip", (Throwable)e);
        }
        return null;
    }
}

