/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.input.TaggedInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.rtf.RTFEmbObjHandler;
import org.apache.tika.parser.microsoft.rtf.TextExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RTFParser
implements Parser {
    private static final long serialVersionUID = -4165069489372320313L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"rtf"));
    private static int EMB_OBJ_MAX_BYTES = 0x1400000;
    private static volatile boolean USE_STATIC = false;
    @Field
    private int memoryLimitInKb = EMB_OBJ_MAX_BYTES / 1024;
    @Field
    private boolean ignoreListMarkup = false;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", "application/rtf");
        TaggedInputStream tagged = new TaggedInputStream(stream);
        try {
            XHTMLContentHandler xhtmlHandler = new XHTMLContentHandler(handler, metadata);
            RTFEmbObjHandler embObjHandler = new RTFEmbObjHandler((ContentHandler)xhtmlHandler, metadata, context, this.getMemoryLimitInKb());
            TextExtractor ert = new TextExtractor(xhtmlHandler, metadata, embObjHandler);
            ert.setIgnoreListMarkup(this.ignoreListMarkup);
            ert.extract(stream);
        }
        catch (IOException e) {
            tagged.throwIfCauseOf((Throwable)e);
            throw new TikaException("Error parsing an RTF document", (Throwable)e);
        }
    }

    public int getMemoryLimitInKb() {
        if (USE_STATIC) {
            if (EMB_OBJ_MAX_BYTES < 0) {
                return EMB_OBJ_MAX_BYTES;
            }
            return EMB_OBJ_MAX_BYTES / 1024;
        }
        return this.memoryLimitInKb;
    }

    @Field
    public void setMemoryLimitInKb(int memoryLimitInKb) {
        this.memoryLimitInKb = memoryLimitInKb;
        USE_STATIC = false;
    }
}

