/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.step.map;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeVertexStep;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class TinkerMergeVertexStep<S>
extends MergeVertexStep<S> {
    public TinkerMergeVertexStep(MergeVertexStep step) {
        super(step.getTraversal(), step.isStart(), step.getSearchCreateTraversal());
        if (step.getOnMatchTraversal() != null) {
            this.addChildOption(Merge.onMatch, step.getOnMatchTraversal());
        }
        if (step.getOnCreateTraversal() != null) {
            this.addChildOption(Merge.onCreate, step.getOnCreateTraversal());
        }
        if (step.getCallbackRegistry() != null) {
            this.callbackRegistry = step.getCallbackRegistry();
        }
    }

    protected Stream<Vertex> createSearchStream(Map<Object, Object> search) {
        Stream stream;
        TinkerGraph graph = (TinkerGraph)this.getTraversal().getGraph().get();
        Optional<Object> firstIndex = Optional.empty();
        if (null == search) {
            return Stream.empty();
        }
        if (search.containsKey(T.id)) {
            stream = IteratorUtils.stream(graph.vertices(search.get(T.id)));
        } else {
            Set<String> indexedKeys = graph.getIndexedKeys(Vertex.class);
            firstIndex = search.keySet().stream().filter(k -> k instanceof String).map(k -> (String)k).filter(indexedKeys::contains).findFirst();
            stream = firstIndex.map(s -> TinkerHelper.queryVertexIndex(graph, s, search.get(s)).stream().map(v -> v)).orElseGet(() -> IteratorUtils.stream(graph.vertices(new Object[0])));
        }
        Optional indexUsed = firstIndex;
        stream = stream.filter(v -> search.entrySet().stream().filter(kv -> {
            Object k = kv.getKey();
            return k != T.id && (!indexUsed.isPresent() || !((String)indexUsed.get()).equals(k));
        }).allMatch(kv -> {
            if (kv.getKey() == T.label) {
                return v.label().equals(kv.getValue());
            }
            VertexProperty vp = v.property(kv.getKey().toString());
            return vp.isPresent() && kv.getValue().equals(vp.value());
        }));
        return stream;
    }
}

