/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.CharacterSetOrientation;
import org.apache.fop.afp.util.ResourceAccessor;
import org.apache.fop.afp.util.StructuredFieldReader;

public final class AFPFontReader {
    protected static final Log log = LogFactory.getLog((Class)AFPFontReader.class);
    private static final CharacterSetOrientation[] EMPTY_CSO_ARRAY = new CharacterSetOrientation[0];
    private static final byte[] CODEPAGE_SF = new byte[]{-45, -88, -121};
    private static final byte[] CHARACTER_TABLE_SF = new byte[]{-45, -116, -121};
    private static final byte[] FONT_DESCRIPTOR_SF = new byte[]{-45, -90, -119};
    private static final byte[] FONT_CONTROL_SF = new byte[]{-45, -89, -119};
    private static final byte[] FONT_ORIENTATION_SF = new byte[]{-45, -82, -119};
    private static final byte[] FONT_POSITION_SF = new byte[]{-45, -84, -119};
    private static final byte[] FONT_INDEX_SF = new byte[]{-45, -116, -119};
    private final Map codePagesCache = new HashMap();

    private InputStream openInputStream(ResourceAccessor accessor, String filename) throws IOException {
        URI uri;
        try {
            uri = new URI(filename.trim());
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException("Invalid filename: " + filename + " (" + e.getMessage() + ")");
        }
        InputStream inputStream = accessor.createInputStream(uri);
        return inputStream;
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCharacterSetMetric(CharacterSet characterSet) throws IOException {
        InputStream inputStream = null;
        try {
            String codePageId = new String(characterSet.getCodePage());
            ResourceAccessor accessor = characterSet.getResourceAccessor();
            Map codePage = (Map)this.codePagesCache.get(codePageId);
            if (codePage == null) {
                codePage = this.loadCodePage(codePageId, characterSet.getEncoding(), accessor);
                this.codePagesCache.put(codePageId, codePage);
            }
            String characterSetName = characterSet.getName();
            inputStream = this.openInputStream(accessor, characterSetName);
            StructuredFieldReader structuredFieldReader = new StructuredFieldReader(inputStream);
            int pointSize = AFPFontReader.processFontDescriptor(structuredFieldReader);
            FontControl fontControl = this.processFontControl(structuredFieldReader);
            if (fontControl != null) {
                CharacterSetOrientation[] characterSetOrientations = this.processFontOrientation(structuredFieldReader);
                int dpi = fontControl.getDpi();
                int metricNormalizationFactor = 0;
                metricNormalizationFactor = fontControl.isRelative() ? 1 : 72000 / dpi / pointSize;
                this.processFontPosition(structuredFieldReader, characterSetOrientations, metricNormalizationFactor);
                for (int i = 0; i < characterSetOrientations.length; ++i) {
                    this.processFontIndex(structuredFieldReader, characterSetOrientations[i], codePage, metricNormalizationFactor);
                    characterSet.addCharacterSetOrientation(characterSetOrientations[i]);
                }
            } else {
                throw new IOException("Failed to read font control structured field in character set " + characterSetName);
            }
            this.closeInputStream(inputStream);
        }
        catch (Throwable throwable) {
            this.closeInputStream(inputStream);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadCodePage(String codePage, String encoding, ResourceAccessor accessor) throws IOException {
        HashMap<String, String> codePages = new HashMap<String, String>();
        InputStream inputStream = null;
        try {
            inputStream = this.openInputStream(accessor, codePage.trim());
            StructuredFieldReader structuredFieldReader = new StructuredFieldReader(inputStream);
            byte[] data = structuredFieldReader.getNext(CHARACTER_TABLE_SF);
            int position = 0;
            byte[] gcgiBytes = new byte[8];
            byte[] charBytes = new byte[1];
            for (int index = 3; index < data.length; ++index) {
                if (position < 8) {
                    gcgiBytes[position] = data[index];
                    ++position;
                    continue;
                }
                if (position == 9) {
                    position = 0;
                    charBytes[0] = data[index];
                    String gcgiString = new String(gcgiBytes, "Cp1146");
                    String charString = new String(charBytes, encoding);
                    codePages.put(gcgiString, charString);
                    continue;
                }
                ++position;
            }
            this.closeInputStream(inputStream);
        }
        catch (Throwable throwable) {
            this.closeInputStream(inputStream);
            throw throwable;
        }
        return codePages;
    }

    private static int processFontDescriptor(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] fndData = structuredFieldReader.getNext(FONT_DESCRIPTOR_SF);
        int nominalPointSize = (((fndData[39] & 0xFF) << 8) + (fndData[40] & 0xFF)) / 10;
        return nominalPointSize;
    }

    private FontControl processFontControl(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] fncData = structuredFieldReader.getNext(FONT_CONTROL_SF);
        FontControl fontControl = null;
        if (fncData != null) {
            fontControl = new FontControl();
            if (fncData[7] == 2) {
                fontControl.setRelative(true);
            }
            int metricResolution = (((fncData[9] & 0xFF) << 8) + (fncData[10] & 0xFF)) / 10;
            fontControl.setDpi(metricResolution);
        }
        return fontControl;
    }

    private CharacterSetOrientation[] processFontOrientation(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] data = structuredFieldReader.getNext(FONT_ORIENTATION_SF);
        int position = 0;
        byte[] fnoData = new byte[26];
        ArrayList<CharacterSetOrientation> orientations = new ArrayList<CharacterSetOrientation>();
        for (int index = 3; index < data.length; ++index) {
            fnoData[position] = data[index];
            if (++position != 26) continue;
            position = 0;
            int orientation = 0;
            switch (fnoData[2]) {
                case 0: {
                    orientation = 0;
                    break;
                }
                case 45: {
                    orientation = 90;
                    break;
                }
                case 90: {
                    orientation = 180;
                    break;
                }
                case -121: {
                    orientation = 270;
                    break;
                }
                default: {
                    System.out.println("ERROR: Oriantation");
                }
            }
            CharacterSetOrientation cso = new CharacterSetOrientation(orientation);
            orientations.add(cso);
        }
        return orientations.toArray(EMPTY_CSO_ARRAY);
    }

    private void processFontPosition(StructuredFieldReader structuredFieldReader, CharacterSetOrientation[] characterSetOrientations, int metricNormalizationFactor) throws IOException {
        byte[] data = structuredFieldReader.getNext(FONT_POSITION_SF);
        int position = 0;
        byte[] fpData = new byte[26];
        int characterSetOrientationIndex = 0;
        for (int index = 3; index < data.length; ++index) {
            if (position < 22) {
                fpData[position] = data[index];
                if (position == 9) {
                    CharacterSetOrientation characterSetOrientation = characterSetOrientations[characterSetOrientationIndex];
                    int xHeight = ((fpData[2] & 0xFF) << 8) + (fpData[3] & 0xFF);
                    int capHeight = ((fpData[4] & 0xFF) << 8) + (fpData[5] & 0xFF);
                    int ascHeight = ((fpData[6] & 0xFF) << 8) + (fpData[7] & 0xFF);
                    int dscHeight = ((fpData[8] & 0xFF) << 8) + (fpData[9] & 0xFF);
                    characterSetOrientation.setXHeight(xHeight * metricNormalizationFactor);
                    characterSetOrientation.setCapHeight(capHeight * metricNormalizationFactor);
                    characterSetOrientation.setAscender(ascHeight * metricNormalizationFactor);
                    characterSetOrientation.setDescender((dscHeight *= -1) * metricNormalizationFactor);
                }
            } else if (position == 22) {
                position = 0;
                ++characterSetOrientationIndex;
                fpData[position] = data[index];
            }
            ++position;
        }
    }

    private void processFontIndex(StructuredFieldReader structuredFieldReader, CharacterSetOrientation cso, Map codepage, int metricNormalizationFactor) throws IOException {
        byte[] data = structuredFieldReader.getNext(FONT_INDEX_SF);
        int position = 0;
        byte[] gcgid = new byte[8];
        byte[] fiData = new byte[20];
        char lowest = '\u00ff';
        char highest = '\u0000';
        for (int index = 3; index < data.length; ++index) {
            if (position < 8) {
                gcgid[position] = data[index];
                ++position;
                continue;
            }
            if (position < 27) {
                fiData[position - 8] = data[index];
                ++position;
                continue;
            }
            if (position != 27) continue;
            fiData[position - 8] = data[index];
            position = 0;
            String gcgiString = new String(gcgid, "Cp1146");
            String idx = (String)codepage.get(gcgiString);
            if (idx == null) continue;
            char cidx = idx.charAt(0);
            int width = ((fiData[0] & 0xFF) << 8) + (fiData[1] & 0xFF);
            if (cidx < lowest) {
                lowest = cidx;
            }
            if (cidx > highest) {
                highest = cidx;
            }
            int a = width * metricNormalizationFactor;
            cso.setWidth(cidx, a);
        }
        cso.setFirstChar(lowest);
        cso.setLastChar(highest);
    }

    private class FontControl {
        private int dpi;
        private boolean isRelative = false;

        private FontControl() {
        }

        public int getDpi() {
            return this.dpi;
        }

        public void setDpi(int i) {
            this.dpi = i;
        }

        public boolean isRelative() {
            return this.isRelative;
        }

        public void setRelative(boolean b) {
            this.isRelative = b;
        }
    }
}

