/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.list;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KeepUtil;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.list.ListItemContentLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class ListItemLayoutManager
extends BlockStackingLayoutManager
implements ConditionalElementListener {
    private static Log log;
    private ListItemContentLayoutManager label;
    private ListItemContentLayoutManager body;
    private Block curBlockArea = null;
    private List labelList = null;
    private List bodyList = null;
    private boolean discardBorderBefore;
    private boolean discardBorderAfter;
    private boolean discardPaddingBefore;
    private boolean discardPaddingAfter;
    private MinOptMax effSpaceBefore;
    private MinOptMax effSpaceAfter;
    private int keepWithNextPendingOnLabel;
    private int keepWithNextPendingOnBody;
    private int listItemHeight;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ListItemLayoutManager(ListItem node) {
        super(node);
        this.setLabel(node.getLabel());
        this.setBody(node.getBody());
    }

    protected ListItem getListItemFO() {
        return (ListItem)this.fobj;
    }

    public void setLabel(ListItemLabel node) {
        this.label = new ListItemContentLayoutManager(node);
        this.label.setParent(this);
    }

    public void setBody(ListItemBody node) {
        this.body = new ListItemContentLayoutManager(node);
        this.body.setParent(this);
    }

    public void initialize() {
        this.foSpaceBefore = new SpaceVal(this.getListItemFO().getCommonMarginBlock().spaceBefore, this).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getListItemFO().getCommonMarginBlock().spaceAfter, this).getSpace();
        this.startIndent = this.getListItemFO().getCommonMarginBlock().startIndent.getValue(this);
        this.endIndent = this.getListItemFO().getCommonMarginBlock().endIndent.getValue(this);
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    public List getNextKnuthElements(LayoutContext context, int alignment) {
        this.referenceIPD = context.getRefIPD();
        LinkedList returnList = new LinkedList();
        if (!this.breakBeforeServed) {
            this.breakBeforeServed = true;
            if (!context.suppressBreakBefore() && this.addKnuthElementsForBreakBefore(returnList, context)) {
                return returnList;
            }
        }
        this.addKnuthElementsForSpaceBefore(returnList, alignment);
        this.addKnuthElementsForBorderPaddingBefore(returnList, !this.firstVisibleMarkServed);
        this.firstVisibleMarkServed = true;
        this.addPendingMarks(context);
        LayoutContext childLC = new LayoutContext(0);
        childLC.setRefIPD(context.getRefIPD());
        this.label.initialize();
        this.labelList = this.label.getNextKnuthElements(childLC, alignment);
        SpaceResolver.resolveElementList(this.labelList);
        ElementListObserver.observe(this.labelList, "list-item-label", this.label.getPartFO().getId());
        context.updateKeepWithPreviousPending(childLC.getKeepWithPreviousPending());
        this.keepWithNextPendingOnLabel = childLC.getKeepWithNextPending();
        childLC = new LayoutContext(0);
        childLC.setRefIPD(context.getRefIPD());
        this.body.initialize();
        this.bodyList = this.body.getNextKnuthElements(childLC, alignment);
        SpaceResolver.resolveElementList(this.bodyList);
        ElementListObserver.observe(this.bodyList, "list-item-body", this.body.getPartFO().getId());
        context.updateKeepWithPreviousPending(childLC.getKeepWithPreviousPending());
        this.keepWithNextPendingOnBody = childLC.getKeepWithNextPending();
        List returnedList = this.getCombinedKnuthElementsForListItem(this.labelList, this.bodyList, context);
        this.wrapPositionElements(returnedList, returnList, true);
        this.addKnuthElementsForBorderPaddingAfter(returnList, true);
        this.addKnuthElementsForSpaceAfter(returnList, alignment);
        this.addKnuthElementsForBreakAfter(returnList, context);
        context.updateKeepWithNextPending(this.keepWithNextPendingOnLabel);
        context.updateKeepWithNextPending(this.keepWithNextPendingOnBody);
        context.updateKeepWithNextPending(this.getKeepWithNextStrength());
        context.updateKeepWithPreviousPending(this.getKeepWithPreviousStrength());
        this.setFinished(true);
        this.resetSpaces();
        return returnList;
    }

    private List getCombinedKnuthElementsForListItem(List labelElements, List bodyElements, LayoutContext context) {
        int step;
        List[] elementLists = new List[]{new ArrayList(labelElements), new ArrayList(bodyElements)};
        int[] fullHeights = new int[]{ElementListUtils.calcContentLength(elementLists[0]), ElementListUtils.calcContentLength(elementLists[1])};
        int[] partialHeights = new int[]{0, 0};
        int[] start = new int[]{-1, -1};
        int[] end = new int[]{-1, -1};
        int totalHeight = Math.max(fullHeights[0], fullHeights[1]);
        int addedBoxHeight = 0;
        int keepWithNextActive = Integer.MIN_VALUE;
        LinkedList<ListElement> returnList = new LinkedList<ListElement>();
        while ((step = this.getNextStep(elementLists, start, end, partialHeights)) > 0) {
            if (end[0] + 1 == elementLists[0].size()) {
                keepWithNextActive = Math.max(keepWithNextActive, this.keepWithNextPendingOnLabel);
            }
            if (end[1] + 1 == elementLists[1].size()) {
                keepWithNextActive = Math.max(keepWithNextActive, this.keepWithNextPendingOnBody);
            }
            int penaltyHeight = step + this.getMaxRemainingHeight(fullHeights, partialHeights) - totalHeight;
            int additionalPenaltyHeight = 0;
            int stepPenalty = 0;
            KnuthElement endEl = (KnuthElement)elementLists[0].get(end[0]);
            if (endEl instanceof KnuthPenalty) {
                additionalPenaltyHeight = endEl.getW();
                stepPenalty = Math.max(stepPenalty, endEl.getP());
            }
            if ((endEl = (KnuthElement)elementLists[1].get(end[1])) instanceof KnuthPenalty) {
                additionalPenaltyHeight = Math.max(additionalPenaltyHeight, endEl.getW());
                stepPenalty = Math.max(stepPenalty, endEl.getP());
            }
            int boxHeight = step - addedBoxHeight - penaltyHeight;
            penaltyHeight += additionalPenaltyHeight;
            LinkedList footnoteList = null;
            for (int i = 0; i < elementLists.length; ++i) {
                for (int j = start[i]; j <= end[i]; ++j) {
                    ListElement el = (ListElement)elementLists[i].get(j);
                    if (!(el instanceof KnuthBlockBox) || !((KnuthBlockBox)el).hasAnchors()) continue;
                    if (footnoteList == null) {
                        footnoteList = new LinkedList();
                    }
                    footnoteList.addAll(((KnuthBlockBox)el).getFootnoteBodyLMs());
                }
            }
            addedBoxHeight += boxHeight;
            ListItemPosition stepPosition = new ListItemPosition(this, start[0], end[0], start[1], end[1]);
            if (footnoteList == null) {
                returnList.add(new KnuthBox(boxHeight, stepPosition, false));
            } else {
                returnList.add(new KnuthBlockBox(boxHeight, footnoteList, stepPosition, false));
            }
            if (addedBoxHeight >= totalHeight) continue;
            int strength = Integer.MIN_VALUE;
            strength = Math.max(strength, keepWithNextActive);
            strength = Math.max(strength, this.getKeepTogetherStrength());
            int p = stepPenalty;
            if (p > -1000) {
                p = Math.max(p, KeepUtil.getPenaltyForKeep(strength));
            }
            returnList.add(new BreakElement(stepPosition, penaltyHeight, p, -1, context));
        }
        return returnList;
    }

    private int getNextStep(List[] elementLists, int[] start, int[] end, int[] partialHeights) {
        int[] backupHeights = new int[]{partialHeights[0], partialHeights[1]};
        start[0] = end[0] + 1;
        start[1] = end[1] + 1;
        int seqCount = 0;
        for (int i = 0; i < start.length; ++i) {
            while (end[i] + 1 < elementLists[i].size()) {
                int n = i;
                end[n] = end[n] + 1;
                KnuthElement el = (KnuthElement)elementLists[i].get(end[i]);
                if (el.isPenalty()) {
                    if (el.getP() >= 1000) continue;
                    break;
                }
                if (el.isGlue()) {
                    KnuthElement prev;
                    if (end[i] > 0 && (prev = (KnuthElement)elementLists[i].get(end[i] - 1)).isBox()) break;
                    int n2 = i;
                    partialHeights[n2] = partialHeights[n2] + el.getW();
                    continue;
                }
                int n3 = i;
                partialHeights[n3] = partialHeights[n3] + el.getW();
            }
            if (end[i] < start[i]) {
                partialHeights[i] = backupHeights[i];
                continue;
            }
            ++seqCount;
        }
        if (seqCount == 0) {
            return 0;
        }
        int step = backupHeights[0] == 0 && backupHeights[1] == 0 ? Math.max(end[0] >= start[0] ? partialHeights[0] : Integer.MIN_VALUE, end[1] >= start[1] ? partialHeights[1] : Integer.MIN_VALUE) : Math.min(end[0] >= start[0] ? partialHeights[0] : Integer.MAX_VALUE, end[1] >= start[1] ? partialHeights[1] : Integer.MAX_VALUE);
        for (int i = 0; i < partialHeights.length; ++i) {
            if (partialHeights[i] <= step) continue;
            partialHeights[i] = backupHeights[i];
            end[i] = start[i] - 1;
        }
        return step;
    }

    private int getMaxRemainingHeight(int[] fullHeights, int[] partialHeights) {
        return Math.max(fullHeights[0] - partialHeights[0], fullHeights[1] - partialHeights[1]);
    }

    public List getChangedKnuthElements(List oldList, int alignment) {
        LinkedList<KnuthElement> returnedList;
        this.labelList = this.label.getChangedKnuthElements(this.labelList, alignment);
        ListIterator oldListIterator = oldList.listIterator();
        while (oldListIterator.hasNext()) {
            KnuthElement oldElement = (KnuthElement)oldListIterator.next();
            Position innerPosition = oldElement.getPosition().getPosition();
            if (innerPosition != null) {
                oldElement.setPosition(innerPosition);
                continue;
            }
            oldElement.setPosition(new Position(this));
        }
        LinkedList<KnuthElement> tempList = returnedList = this.body.getChangedKnuthElements(oldList, alignment);
        returnedList = new LinkedList<KnuthElement>();
        ListIterator listIter = tempList.listIterator();
        while (listIter.hasNext()) {
            KnuthElement tempElement = (KnuthElement)listIter.next();
            tempElement.setPosition(new NonLeafPosition(this, tempElement.getPosition()));
            returnedList.add(tempElement);
        }
        return returnedList;
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        this.addId();
        LayoutContext lc = new LayoutContext(0);
        Position firstPos = null;
        Position lastPos = null;
        LinkedList<Position> positionList = new LinkedList<Position>();
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos.getIndex() >= 0) {
                if (firstPos == null) {
                    firstPos = pos;
                }
                lastPos = pos;
            }
            if (!(pos instanceof NonLeafPosition) || pos.getPosition() == null) continue;
            positionList.add(pos.getPosition());
        }
        this.addMarkersToPage(true, this.isFirst(firstPos), this.isLast(lastPos));
        int labelFirstIndex = ((ListItemPosition)positionList.getFirst()).getLabelFirstIndex();
        int labelLastIndex = ((ListItemPosition)positionList.getLast()).getLabelLastIndex();
        int bodyFirstIndex = ((ListItemPosition)positionList.getFirst()).getBodyFirstIndex();
        int bodyLastIndex = ((ListItemPosition)positionList.getLast()).getBodyLastIndex();
        int previousBreak = ElementListUtils.determinePreviousBreak(this.labelList, labelFirstIndex);
        SpaceResolver.performConditionalsNotification(this.labelList, labelFirstIndex, labelLastIndex, previousBreak);
        previousBreak = ElementListUtils.determinePreviousBreak(this.bodyList, bodyFirstIndex);
        SpaceResolver.performConditionalsNotification(this.bodyList, bodyFirstIndex, bodyLastIndex, previousBreak);
        if (labelFirstIndex <= labelLastIndex) {
            KnuthPossPosIter labelIter = new KnuthPossPosIter(this.labelList, labelFirstIndex, labelLastIndex + 1);
            lc.setFlags(32, layoutContext.isFirstArea());
            lc.setFlags(128, layoutContext.isLastArea());
            lc.setSpaceAdjust(layoutContext.getSpaceAdjust());
            lc.setStackLimitBP(layoutContext.getStackLimitBP());
            this.label.addAreas(labelIter, lc);
        }
        if (bodyFirstIndex <= bodyLastIndex) {
            KnuthPossPosIter bodyIter = new KnuthPossPosIter(this.bodyList, bodyFirstIndex, bodyLastIndex + 1);
            lc.setFlags(32, layoutContext.isFirstArea());
            lc.setFlags(128, layoutContext.isLastArea());
            lc.setSpaceAdjust(layoutContext.getSpaceAdjust());
            lc.setStackLimitBP(layoutContext.getStackLimitBP());
            this.body.addAreas(bodyIter, lc);
        }
        int childCount = this.curBlockArea.getChildAreas().size();
        if (!($assertionsDisabled || childCount >= 1 && childCount <= 2)) {
            throw new AssertionError();
        }
        int itemBPD = ((Block)this.curBlockArea.getChildAreas().get(0)).getAllocBPD();
        if (childCount == 2) {
            itemBPD = Math.max(itemBPD, ((Block)this.curBlockArea.getChildAreas().get(1)).getAllocBPD());
        }
        this.curBlockArea.setBPD(itemBPD);
        this.addMarkersToPage(false, this.isFirst(firstPos), this.isLast(lastPos));
        TraitSetter.addBackground(this.curBlockArea, this.getListItemFO().getCommonBorderPaddingBackground(), this);
        TraitSetter.addSpaceBeforeAfter(this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.curBlockArea = null;
        this.resetSpaces();
        this.checkEndOfLayout(lastPos);
    }

    public int getListItemHeight() {
        return this.listItemHeight;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.parentLM.getParentArea(this.curBlockArea);
            TraitSetter.setProducerID(this.curBlockArea, this.getListItemFO().getId());
            TraitSetter.addBorders(this.curBlockArea, this.getListItemFO().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, this);
            TraitSetter.addPadding(this.curBlockArea, this.getListItemFO().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, this);
            TraitSetter.addMargins(this.curBlockArea, this.getListItemFO().getCommonBorderPaddingBackground(), this.getListItemFO().getCommonMarginBlock(), this);
            TraitSetter.addBreaks(this.curBlockArea, this.getListItemFO().getBreakBefore(), this.getListItemFO().getBreakAfter());
            int contentIPD = this.referenceIPD - this.getIPIndents();
            this.curBlockArea.setIPD(contentIPD);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public int getKeepTogetherStrength() {
        int strength = KeepUtil.getCombinedBlockLevelKeepStrength(this.getListItemFO().getKeepTogether());
        strength = Math.max(strength, this.getParentKeepTogetherStrength());
        return strength;
    }

    public int getKeepWithNextStrength() {
        return KeepUtil.getCombinedBlockLevelKeepStrength(this.getListItemFO().getKeepWithNext());
    }

    public int getKeepWithPreviousStrength() {
        return KeepUtil.getCombinedBlockLevelKeepStrength(this.getListItemFO().getKeepWithPrevious());
    }

    public void notifySpace(RelSide side, MinOptMax effectiveLength) {
        if (RelSide.BEFORE == side) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + side + ", " + this.effSpaceBefore + "-> " + effectiveLength));
            }
            this.effSpaceBefore = effectiveLength;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + side + ", " + this.effSpaceAfter + "-> " + effectiveLength));
            }
            this.effSpaceAfter = effectiveLength;
        }
    }

    public void notifyBorder(RelSide side, MinOptMax effectiveLength) {
        if (effectiveLength == null) {
            if (RelSide.BEFORE == side) {
                this.discardBorderBefore = true;
            } else {
                this.discardBorderAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Border " + side + " -> " + effectiveLength));
        }
    }

    public void notifyPadding(RelSide side, MinOptMax effectiveLength) {
        if (effectiveLength == null) {
            if (RelSide.BEFORE == side) {
                this.discardPaddingBefore = true;
            } else {
                this.discardPaddingAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Padding " + side + " -> " + effectiveLength));
        }
    }

    static {
        $assertionsDisabled = !ListItemLayoutManager.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)ListItemLayoutManager.class);
    }

    private class ListItemPosition
    extends Position {
        private int iLabelFirstIndex;
        private int iLabelLastIndex;
        private int iBodyFirstIndex;
        private int iBodyLastIndex;

        public ListItemPosition(LayoutManager lm, int labelFirst, int labelLast, int bodyFirst, int bodyLast) {
            super(lm);
            this.iLabelFirstIndex = labelFirst;
            this.iLabelLastIndex = labelLast;
            this.iBodyFirstIndex = bodyFirst;
            this.iBodyLastIndex = bodyLast;
        }

        public int getLabelFirstIndex() {
            return this.iLabelFirstIndex;
        }

        public int getLabelLastIndex() {
            return this.iLabelLastIndex;
        }

        public int getBodyFirstIndex() {
            return this.iBodyFirstIndex;
        }

        public int getBodyLastIndex() {
            return this.iBodyLastIndex;
        }

        public boolean generatesAreas() {
            return true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("ListItemPosition:");
            sb.append(this.getIndex()).append("(");
            sb.append("label:").append(this.iLabelFirstIndex).append("-").append(this.iLabelLastIndex);
            sb.append(" body:").append(this.iBodyFirstIndex).append("-").append(this.iBodyLastIndex);
            sb.append(")");
            return sb.toString();
        }
    }
}

