/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.Nullable;

@GwtCompatible
public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, char p1) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1)));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, int p1) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, long p1) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, char p1, char p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), Character.valueOf(p2)));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, char p1, int p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, char p1, long p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, char p1, @Nullable Object p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, int p1, char p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, int p1, int p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, int p1, long p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, int p1, @Nullable Object p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, long p1, char p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, long p1, int p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, long p1, long p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, long p1, @Nullable Object p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, char p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, int p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, long p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static void checkArgument(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2, p3, p4));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, char p1) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1)));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, int p1) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, long p1) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, char p1, char p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), Character.valueOf(p2)));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, char p1, int p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, char p1, long p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, char p1, @Nullable Object p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, int p1, char p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, int p1, int p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, int p1, long p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, int p1, @Nullable Object p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, long p1, char p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, long p1, int p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, long p1, long p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, long p1, @Nullable Object p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, char p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, int p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, long p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static void checkState(boolean b2, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        if (!b2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2, p3, p4));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference2) {
        if (reference2 == null) {
            throw new NullPointerException();
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference2, @Nullable Object errorMessage) {
        if (reference2 == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference2, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference2 == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, char p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1)));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, int p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, long p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, @Nullable Object p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, char p1, char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), Character.valueOf(p2)));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, char p1, int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, char p1, long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, char p1, @Nullable Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, int p1, char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, int p1, int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, int p1, long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, int p1, @Nullable Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, long p1, char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, long p1, int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, long p1, long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, long p1, @Nullable Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2, p3));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2, p3, p4));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int index2, int size2) {
        return Preconditions.checkElementIndex(index2, size2, "index");
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int index2, int size2, @Nullable String desc) {
        if (index2 < 0 || index2 >= size2) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(index2, size2, desc));
        }
        return index2;
    }

    private static String badElementIndex(int index2, int size2, String desc) {
        if (index2 < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index2);
        }
        if (size2 < 0) {
            throw new IllegalArgumentException("negative size: " + size2);
        }
        return Preconditions.format("%s (%s) must be less than size (%s)", desc, index2, size2);
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int index2, int size2) {
        return Preconditions.checkPositionIndex(index2, size2, "index");
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int index2, int size2, @Nullable String desc) {
        if (index2 < 0 || index2 > size2) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(index2, size2, desc));
        }
        return index2;
    }

    private static String badPositionIndex(int index2, int size2, String desc) {
        if (index2 < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index2);
        }
        if (size2 < 0) {
            throw new IllegalArgumentException("negative size: " + size2);
        }
        return Preconditions.format("%s (%s) must not be greater than size (%s)", desc, index2, size2);
    }

    public static void checkPositionIndexes(int start2, int end2, int size2) {
        if (start2 < 0 || end2 < start2 || end2 > size2) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(start2, end2, size2));
        }
    }

    private static String badPositionIndexes(int start2, int end2, int size2) {
        if (start2 < 0 || start2 > size2) {
            return Preconditions.badPositionIndex(start2, size2, "start index");
        }
        if (end2 < 0 || end2 > size2) {
            return Preconditions.badPositionIndex(end2, size2, "end index");
        }
        return Preconditions.format("end index (%s) must not be less than start index (%s)", end2, start2);
    }

    static String format(String template, Object ... args2) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args2.length);
        int templateStart = 0;
        int i2 = 0;
        while (i2 < args2.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args2[i2++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i2 < args2.length) {
            builder.append(" [");
            builder.append(args2[i2++]);
            while (i2 < args2.length) {
                builder.append(", ");
                builder.append(args2[i2++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

