/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    @Nullable
    private transient Map.Entry<K, V> entrySetCache;

    MapIteratorCache(Map<K, V> backingMap) {
        this.backingMap = Preconditions.checkNotNull(backingMap);
    }

    @CanIgnoreReturnValue
    public V put(@Nullable K key2, @Nullable V value2) {
        this.clearCache();
        return this.backingMap.put(key2, value2);
    }

    @CanIgnoreReturnValue
    public V remove(@Nullable Object key2) {
        this.clearCache();
        return this.backingMap.remove(key2);
    }

    public void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    public V get(@Nullable Object key2) {
        V value2 = this.getIfCached(key2);
        return value2 != null ? value2 : this.getWithoutCaching(key2);
    }

    public final V getWithoutCaching(@Nullable Object key2) {
        return this.backingMap.get(key2);
    }

    public final boolean containsKey(@Nullable Object key2) {
        return this.getIfCached(key2) != null || this.backingMap.containsKey(key2);
    }

    public final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            @Override
            public UnmodifiableIterator<K> iterator() {
                final Iterator entryIterator = MapIteratorCache.this.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return entryIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry = (Map.Entry)entryIterator.next();
                        MapIteratorCache.this.entrySetCache = entry;
                        return entry.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }

            @Override
            public boolean contains(@Nullable Object key2) {
                return MapIteratorCache.this.containsKey(key2);
            }
        };
    }

    protected V getIfCached(@Nullable Object key2) {
        Map.Entry<K, V> entry = this.entrySetCache;
        if (entry != null && entry.getKey() == key2) {
            return entry.getValue();
        }
        return null;
    }

    protected void clearCache() {
        this.entrySetCache = null;
    }
}

