/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

@GwtCompatible
public final class Longs {
    public static final int BYTES = 8;
    public static final long MAX_POWER_OF_TWO = 0x4000000000000000L;
    private static final byte[] asciiDigits = Longs.createAsciiDigits();

    private Longs() {
    }

    public static int hashCode(long value2) {
        return (int)(value2 ^ value2 >>> 32);
    }

    public static int compare(long a, long b2) {
        return a < b2 ? -1 : (a > b2 ? 1 : 0);
    }

    public static boolean contains(long[] array, long target) {
        for (long value2 : array) {
            if (value2 != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(long[] array, long target) {
        return Longs.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(long[] array, long target, int start2, int end2) {
        for (int i2 = start2; i2 < end2; ++i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(long[] array, long[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array.length - target.length + 1; ++i2) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i2 + j] != target[j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long target) {
        return Longs.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(long[] array, long target, int start2, int end2) {
        for (int i2 = end2 - 1; i2 >= start2; --i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static long min(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long min2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= min2) continue;
            min2 = array[i2];
        }
        return min2;
    }

    public static long max(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long max2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] <= max2) continue;
            max2 = array[i2];
        }
        return max2;
    }

    public static long[] concat(long[] ... arrays) {
        int length2 = 0;
        for (long[] array : arrays) {
            length2 += array.length;
        }
        long[] result2 = new long[length2];
        int pos2 = 0;
        for (long[] array : arrays) {
            System.arraycopy(array, 0, result2, pos2, array.length);
            pos2 += array.length;
        }
        return result2;
    }

    public static byte[] toByteArray(long value2) {
        byte[] result2 = new byte[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            result2[i2] = (byte)(value2 & 0xFFL);
            value2 >>= 8;
        }
        return result2;
    }

    public static long fromByteArray(byte[] bytes2) {
        Preconditions.checkArgument(bytes2.length >= 8, "array too small: %s < %s", bytes2.length, 8);
        return Longs.fromBytes(bytes2[0], bytes2[1], bytes2[2], bytes2[3], bytes2[4], bytes2[5], bytes2[6], bytes2[7]);
    }

    public static long fromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }

    private static byte[] createAsciiDigits() {
        int i2;
        byte[] result2 = new byte[128];
        Arrays.fill(result2, (byte)-1);
        for (i2 = 0; i2 <= 9; ++i2) {
            result2[48 + i2] = (byte)i2;
        }
        for (i2 = 0; i2 <= 26; ++i2) {
            result2[65 + i2] = (byte)(10 + i2);
            result2[97 + i2] = (byte)(10 + i2);
        }
        return result2;
    }

    private static int digit(char c) {
        return c < '\u0080' ? asciiDigits[c] : -1;
    }

    @Nullable
    @CheckForNull
    @Beta
    public static Long tryParse(String string2) {
        return Longs.tryParse(string2, 10);
    }

    @Nullable
    @CheckForNull
    @Beta
    public static Long tryParse(String string2, int radix) {
        int digit;
        int index2;
        if (Preconditions.checkNotNull(string2).isEmpty()) {
            return null;
        }
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("radix must be between MIN_RADIX and MAX_RADIX but was " + radix);
        }
        boolean negative = string2.charAt(0) == '-';
        int n = index2 = negative ? 1 : 0;
        if (index2 == string2.length()) {
            return null;
        }
        if ((digit = Longs.digit(string2.charAt(index2++))) < 0 || digit >= radix) {
            return null;
        }
        long accum = -digit;
        long cap = Long.MIN_VALUE / (long)radix;
        while (index2 < string2.length()) {
            if ((digit = Longs.digit(string2.charAt(index2++))) < 0 || digit >= radix || accum < cap) {
                return null;
            }
            if ((accum *= (long)radix) < Long.MIN_VALUE + (long)digit) {
                return null;
            }
            accum -= (long)digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Long.MIN_VALUE) {
            return null;
        }
        return -accum;
    }

    @Beta
    public static Converter<String, Long> stringConverter() {
        return LongConverter.INSTANCE;
    }

    public static long[] ensureCapacity(long[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array.length < minLength ? Arrays.copyOf(array, minLength + padding) : array;
    }

    public static String join(String separator, long ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 10);
        builder.append(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            builder.append(separator).append(array[i2]);
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static long[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof LongArrayAsList) {
            return ((LongArrayAsList)collection).toLongArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        long[] array = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array[i2] = ((Number)Preconditions.checkNotNull(boxedArray[i2])).longValue();
        }
        return array;
    }

    public static List<Long> asList(long ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new LongArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class LongArrayAsList
    extends AbstractList<Long>
    implements RandomAccess,
    Serializable {
        final long[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        LongArrayAsList(long[] array) {
            this(array, 0, array.length);
        }

        LongArrayAsList(long[] array, int start2, int end2) {
            this.array = array;
            this.start = start2;
            this.end = end2;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Long get(int index2) {
            Preconditions.checkElementIndex(index2, this.size());
            return this.array[this.start + index2];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Long && Longs.indexOf(this.array, (Long)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int i2;
            if (target instanceof Long && (i2 = Longs.indexOf(this.array, (Long)target, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int i2;
            if (target instanceof Long && (i2 = Longs.lastIndexOf(this.array, (Long)target, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public Long set(int index2, Long element) {
            Preconditions.checkElementIndex(index2, this.size());
            long oldValue = this.array[this.start + index2];
            this.array[this.start + index2] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            int size2 = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size2);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new LongArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayAsList) {
                LongArrayAsList that = (LongArrayAsList)object;
                int size2 = this.size();
                if (that.size() != size2) {
                    return false;
                }
                for (int i2 = 0; i2 < size2; ++i2) {
                    if (this.array[this.start + i2] == that.array[that.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                result2 = 31 * result2 + Longs.hashCode(this.array[i2]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 10);
            builder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                builder.append(", ").append(this.array[i2]);
            }
            return builder.append(']').toString();
        }

        long[] toLongArray() {
            int size2 = this.size();
            long[] result2 = new long[size2];
            System.arraycopy(this.array, this.start, result2, 0, size2);
            return result2;
        }
    }

    private static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left2, long[] right) {
            int minLength = Math.min(left2.length, right.length);
            for (int i2 = 0; i2 < minLength; ++i2) {
                int result2 = Longs.compare(left2[i2], right[i2]);
                if (result2 == 0) continue;
                return result2;
            }
            return left2.length - right.length;
        }

        public String toString() {
            return "Longs.lexicographicalComparator()";
        }
    }

    private static final class LongConverter
    extends Converter<String, Long>
    implements Serializable {
        static final LongConverter INSTANCE = new LongConverter();
        private static final long serialVersionUID = 1L;

        private LongConverter() {
        }

        @Override
        protected Long doForward(String value2) {
            return Long.decode(value2);
        }

        @Override
        protected String doBackward(Long value2) {
            return value2.toString();
        }

        public String toString() {
            return "Longs.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

