/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor;

import java.io.File;
import java.util.Map;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;

public class OptionsBuilder {
    private Options options = new Options();

    private OptionsBuilder() {
    }

    public static OptionsBuilder options() {
        return new OptionsBuilder();
    }

    public OptionsBuilder backend(String backend) {
        this.options.setBackend(backend);
        return this;
    }

    public OptionsBuilder docType(String docType) {
        this.options.setDocType(docType);
        return this;
    }

    public OptionsBuilder inPlace(boolean inPlace) {
        this.options.setInPlace(inPlace);
        return this;
    }

    public OptionsBuilder headerFooter(boolean headerFooter) {
        this.options.setHeaderFooter(headerFooter);
        return this;
    }

    public OptionsBuilder templateDir(File templateDir) {
        this.options.setTemplateDirs(templateDir.getAbsolutePath());
        return this;
    }

    public OptionsBuilder templateDirs(File ... templateDirs) {
        for (File templateDir : templateDirs) {
            this.options.setTemplateDirs(templateDir.getAbsolutePath());
        }
        return this;
    }

    public OptionsBuilder templateEngine(String templateEngine) {
        this.options.setTemplateEngine(templateEngine);
        return this;
    }

    public OptionsBuilder templateCache(boolean templateCache) {
        this.options.setTemplateCache(templateCache);
        return this;
    }

    public OptionsBuilder attributes(Map<String, Object> attributes) {
        this.options.setAttributes(attributes);
        return this;
    }

    public OptionsBuilder attributes(Attributes attributes) {
        this.options.setAttributes(attributes.map());
        return this;
    }

    public OptionsBuilder attributes(AttributesBuilder attributes) {
        this.options.setAttributes(attributes.asMap());
        return this;
    }

    public OptionsBuilder toFile(boolean toFile) {
        this.options.setToFile(toFile);
        return this;
    }

    public OptionsBuilder toFile(File toFile) {
        this.options.setToFile(toFile.getPath());
        return this;
    }

    public OptionsBuilder toDir(File directory) {
        this.options.setToDir(directory.getAbsolutePath());
        return this;
    }

    public OptionsBuilder mkDirs(boolean mkDirs) {
        this.options.setMkDirs(mkDirs);
        return this;
    }

    public OptionsBuilder safe(SafeMode safeMode) {
        this.options.setSafe(safeMode);
        return this;
    }

    public OptionsBuilder eruby(String eruby) {
        this.options.setEruby(eruby);
        return this;
    }

    public OptionsBuilder compact(boolean compact2) {
        this.options.setCompact(compact2);
        return this;
    }

    public OptionsBuilder parseHeaderOnly(boolean parseHeaderOnly) {
        this.options.setParseHeaderOnly(parseHeaderOnly);
        return this;
    }

    public OptionsBuilder destinationDir(File destinationDir) {
        this.options.setDestinationDir(destinationDir.getAbsolutePath());
        return this;
    }

    public OptionsBuilder option(String option, Object value2) {
        this.options.setOption(option, value2);
        return this;
    }

    public OptionsBuilder baseDir(File baseDir) {
        this.options.setBaseDir(baseDir.getAbsolutePath());
        return this;
    }

    public Map<String, Object> asMap() {
        return this.options.map();
    }

    public Options get() {
        return this.options;
    }
}

