/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

public class AntPathMatcher {
    private static final char ASTERISK = '*';
    private static final char QUESTION = '?';
    private static final char BLANK = ' ';
    private static final int ASCII_CASE_DIFFERENCE_VALUE = 32;
    private final char pathSeparator;
    private final boolean ignoreCase;
    private final boolean matchStart;
    private final boolean trimTokens;

    private AntPathMatcher(char pathSeparator, boolean ignoreCase, boolean matchStart, boolean trimTokens) {
        this.pathSeparator = pathSeparator;
        this.ignoreCase = ignoreCase;
        this.matchStart = matchStart;
        this.trimTokens = trimTokens;
    }

    public boolean isMatch(String pattern, String path2) {
        if (pattern.isEmpty()) {
            return path2.isEmpty();
        }
        if (path2.isEmpty() && pattern.charAt(0) == this.pathSeparator) {
            if (this.matchStart) {
                return true;
            }
            if (pattern.length() == 2 && pattern.charAt(1) == '*') {
                return false;
            }
            return this.isMatch(pattern.substring(1), path2);
        }
        char patternStart = pattern.charAt(0);
        if (patternStart == '*') {
            int start2;
            if (pattern.length() == 1) {
                return path2.isEmpty() || path2.charAt(0) != this.pathSeparator && this.isMatch(pattern, path2.substring(1));
            }
            if (this.doubleAsteriskMatch(pattern, path2)) {
                return true;
            }
            for (start2 = 0; start2 < path2.length(); ++start2) {
                if (!this.isMatch(pattern.substring(1), path2.substring(start2))) continue;
                return true;
            }
            return this.isMatch(pattern.substring(1), path2.substring(start2));
        }
        int pointer2 = this.skipBlanks(path2);
        return !path2.isEmpty() && (this.equal(path2.charAt(pointer2), patternStart) || patternStart == '?') && this.isMatch(pattern.substring(1), path2.substring(pointer2 + 1));
    }

    private boolean doubleAsteriskMatch(String pattern, String path2) {
        if (pattern.charAt(1) != '*') {
            return false;
        }
        if (pattern.length() > 2) {
            return this.isMatch(pattern.substring(3), path2);
        }
        return false;
    }

    private int skipBlanks(String path2) {
        int pointer2;
        if (this.trimTokens) {
            for (pointer2 = 0; !path2.isEmpty() && pointer2 < path2.length() && path2.charAt(pointer2) == ' '; ++pointer2) {
            }
        }
        return pointer2;
    }

    private boolean equal(char pathChar, char patternChar) {
        if (this.ignoreCase) {
            return pathChar == patternChar || (pathChar > patternChar ? pathChar == patternChar + 32 : pathChar == patternChar - 32);
        }
        return pathChar == patternChar;
    }

    public static final class Builder {
        private char pathSeparator = (char)47;
        private boolean ignoreCase = false;
        private boolean matchStart = false;
        private boolean trimTokens = false;

        public Builder withPathSeparator(char pathSeparator) {
            this.pathSeparator = pathSeparator;
            return this;
        }

        public Builder withIgnoreCase() {
            this.ignoreCase = true;
            return this;
        }

        public Builder withMatchStart() {
            this.matchStart = true;
            return this;
        }

        public Builder withTrimTokens() {
            this.trimTokens = true;
            return this;
        }

        public AntPathMatcher build() {
            return new AntPathMatcher(this.pathSeparator, this.ignoreCase, this.matchStart, this.trimTokens);
        }
    }
}

