/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.sun.javadoc.DocErrorReporter;
import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.asciidoclet.DocletOptions;

class AttributesLoader {
    private final Asciidoctor asciidoctor;
    private final DocletOptions docletOptions;
    private final DocErrorReporter errorReporter;

    AttributesLoader(Asciidoctor asciidoctor, DocletOptions docletOptions, DocErrorReporter errorReporter) {
        this.asciidoctor = asciidoctor;
        this.docletOptions = docletOptions;
        this.errorReporter = errorReporter;
    }

    Map<String, Object> load() {
        List<String> attributeArgs = this.docletOptions.attributes();
        Set<String> unset = this.getUnsetAttributes(attributeArgs);
        Map<String, Object> cmdlineAttrs = this.parseCmdLineAttributes(attributeArgs);
        Map<String, Object> attrs = this.parseAttributesFile(this.docletOptions.attributesFile(), cmdlineAttrs);
        attrs.keySet().removeAll(unset);
        for (String key2 : unset) {
            attrs.put(key2 + "!", "");
        }
        return attrs;
    }

    private Map<String, Object> parseCmdLineAttributes(List<String> attributeArgs) {
        return new Attributes(attributeArgs.toArray(new String[attributeArgs.size()])).map();
    }

    private Map<String, Object> parseAttributesFile(Optional<File> attrsFile, Map<String, Object> cmdlineAttrs) {
        if (attrsFile.isPresent()) {
            try {
                return this.parseAttributes(Files.newReader(attrsFile.get(), this.docletOptions.encoding()), cmdlineAttrs);
            }
            catch (Exception e) {
                this.errorReporter.printWarning("Cannot read attributes file: " + e);
            }
        }
        return cmdlineAttrs;
    }

    private Map<String, Object> parseAttributes(Reader in, Map<String, Object> existingAttrs) {
        OptionsBuilder options2 = OptionsBuilder.options().safe(SafeMode.SAFE).attributes(existingAttrs);
        if (this.docletOptions.baseDir().isPresent()) {
            options2.baseDir(this.docletOptions.baseDir().get());
        }
        Map<String, Object> parsed = this.asciidoctor.readDocumentStructure(in, options2.get().map()).getHeader().getAttributes();
        return new HashMap<String, Object>(parsed);
    }

    private Set<String> getUnsetAttributes(List<String> args2) {
        ImmutableSet.Builder removed = ImmutableSet.builder();
        for (String arg2 : args2) {
            String key2 = this.getKey(arg2);
            if (!key2.startsWith("!") && !key2.endsWith("!")) continue;
            removed.add(this.normalizeAttrName(key2));
        }
        return removed.build();
    }

    private String getKey(String arg2) {
        int idx = arg2.indexOf(61);
        if (idx == 0) {
            throw new IllegalArgumentException("Invalid attribute arg: \"" + arg2 + "\"");
        }
        return idx == -1 ? arg2 : arg2.substring(0, idx);
    }

    private String normalizeAttrName(String name2) {
        return name2.replaceAll("\\W", "").toLowerCase();
    }
}

