/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import com.google.common.base.Optional;
import com.google.common.io.Files;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.asciidoctor.asciidoclet.AntPathMatcher;
import org.asciidoctor.asciidoclet.DocletOptions;
import org.asciidoctor.asciidoclet.DocletRenderer;

public class DocletIterator {
    private static final String ASCIIDOCLET_TAG = "@asciidoclet";
    private static final Pattern ASCIIDOC_FILE_PATTERN = Pattern.compile("(.*\\.(ad|adoc|txt|asciidoc))");
    private final DocletOptions docletOptions;
    private final AntPathMatcher pathMatcher;

    public DocletIterator(DocletOptions docletOptions) {
        this.docletOptions = docletOptions;
        this.pathMatcher = new AntPathMatcher.Builder().withTrimTokens().build();
    }

    public boolean render(RootDoc rootDoc, DocletRenderer renderer) {
        if (!this.processOverview(rootDoc, renderer)) {
            return false;
        }
        HashSet<PackageDoc> packages = new HashSet<PackageDoc>();
        for (ClassDoc doc : rootDoc.classes()) {
            packages.add(doc.containingPackage());
            if (!this.included(doc.qualifiedName(), (Doc)doc)) continue;
            this.renderClass(doc, renderer);
        }
        for (PackageDoc doc : packages) {
            if (!this.included(doc.name(), (Doc)doc)) continue;
            renderer.renderDoc((Doc)doc);
        }
        return true;
    }

    private boolean included(String name2, Doc doc) {
        List<String> includeFilters = this.docletOptions.getIncludeFilters();
        List<String> excludeFilters = this.docletOptions.getExcludeFilters();
        boolean includedMatched = this.matches(includeFilters, name2);
        boolean exclutedMatched = this.matches(excludeFilters, name2);
        boolean result2 = !(!includeFilters.isEmpty() && !includedMatched || !excludeFilters.isEmpty() && exclutedMatched);
        for (Tag tag2 : doc.tags()) {
            result2 |= ASCIIDOCLET_TAG.equals(tag2.name());
        }
        return result2;
    }

    private boolean matches(List<String> patterns, String name2) {
        for (String pattern : patterns) {
            if (!this.pathMatcher.isMatch(pattern, name2)) continue;
            return true;
        }
        return false;
    }

    private void renderClass(ClassDoc doc, DocletRenderer renderer) {
        renderer.renderDoc((Doc)doc);
        for (FieldDoc fieldDoc : doc.fields()) {
            renderer.renderDoc((Doc)fieldDoc);
        }
        for (FieldDoc fieldDoc : doc.constructors()) {
            renderer.renderDoc((Doc)fieldDoc);
        }
        for (FieldDoc fieldDoc : doc.methods()) {
            renderer.renderDoc((Doc)fieldDoc);
        }
        for (FieldDoc fieldDoc : doc.enumConstants()) {
            renderer.renderDoc((Doc)fieldDoc);
        }
        if (doc instanceof AnnotationTypeDoc && !ASCIIDOCLET_TAG.equals(doc.name())) {
            for (FieldDoc fieldDoc : ((AnnotationTypeDoc)doc).elements()) {
                renderer.renderDoc((Doc)fieldDoc);
            }
        }
    }

    private boolean processOverview(RootDoc rootDoc, DocletRenderer renderer) {
        Optional<File> overview = this.docletOptions.overview();
        if (overview.isPresent()) {
            File overviewFile = overview.get();
            if (DocletIterator.isAsciidocFile(overviewFile.getName())) {
                try {
                    String overviewContent = Files.toString(overviewFile, this.docletOptions.encoding());
                    rootDoc.setRawCommentText(overviewContent);
                    renderer.renderDoc((Doc)rootDoc);
                }
                catch (IOException e) {
                    rootDoc.printError("Error reading overview file: " + e.getLocalizedMessage());
                    return false;
                }
            } else {
                rootDoc.printNotice("Skipping non-AsciiDoc overview " + overviewFile + ", will be processed by standard Doclet.");
            }
        }
        return true;
    }

    private static boolean isAsciidocFile(String name2) {
        return ASCIIDOC_FILE_PATTERN.matcher(name2).matches();
    }
}

