/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import org.asciidoctor.ast.AbstractNode;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.BlockImpl;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.CellImpl;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.ColumnImpl;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.DocumentRuby;
import org.asciidoctor.ast.Inline;
import org.asciidoctor.ast.InlineImpl;
import org.asciidoctor.ast.ListImpl;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.ListItemImpl;
import org.asciidoctor.ast.ListNode;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.SectionImpl;
import org.asciidoctor.ast.Table;
import org.asciidoctor.ast.TableImpl;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;

public final class NodeConverter {
    private static final String BLOCK_CLASS = "Asciidoctor::Block";
    private static final String SECTION_CLASS = "Asciidoctor::Section";
    private static final String DOCUMENT_CLASS = "Asciidoctor::Document";
    private static final String INLINE_CLASS = "Asciidoctor::Inline";
    private static final String LIST_CLASS = "Asciidoctor::List";
    private static final String LIST_ITEM_CLASS = "Asciidoctor::ListItem";
    private static final String TABLE_CLASS = "Asciidoctor::Table";
    private static final String TABLE_COLUMN_CLASS = "Asciidoctor::Table::Column";
    private static final String TABLE_CELL_CLASS = "Asciidoctor::Table::Cell";

    private NodeConverter() {
    }

    public static AbstractNode createASTNode(IRubyObject rubyObject) {
        String rubyClassName = rubyObject.getMetaClass().getRealClass().getName();
        Ruby runtime = rubyObject.getRuntime();
        if (BLOCK_CLASS.equals(rubyClassName)) {
            Block blockRuby = RubyUtils.rubyToJava(runtime, rubyObject, Block.class);
            return new BlockImpl(blockRuby, runtime);
        }
        if (SECTION_CLASS.equals(rubyClassName)) {
            Section blockRuby = RubyUtils.rubyToJava(runtime, rubyObject, Section.class);
            return new SectionImpl(blockRuby, runtime);
        }
        if (DOCUMENT_CLASS.equals(rubyClassName)) {
            DocumentRuby blockRuby = RubyUtils.rubyToJava(runtime, rubyObject, DocumentRuby.class);
            return new Document(blockRuby, runtime);
        }
        if (INLINE_CLASS.equals(rubyClassName)) {
            Inline inline = RubyUtils.rubyToJava(runtime, rubyObject, Inline.class);
            return new InlineImpl(inline, runtime);
        }
        if (LIST_CLASS.equals(rubyClassName)) {
            ListNode list2 = RubyUtils.rubyToJava(runtime, rubyObject, ListNode.class);
            return new ListImpl(list2, runtime);
        }
        if (LIST_ITEM_CLASS.equals(rubyClassName)) {
            ListItem list3 = RubyUtils.rubyToJava(runtime, rubyObject, ListItem.class);
            return new ListItemImpl(list3, runtime);
        }
        if (TABLE_CLASS.equals(rubyClassName)) {
            Table table = RubyUtils.rubyToJava(runtime, rubyObject, Table.class);
            return new TableImpl(table, runtime);
        }
        if (TABLE_CELL_CLASS.equals(rubyClassName)) {
            Cell cell = RubyUtils.rubyToJava(runtime, rubyObject, Cell.class);
            return new CellImpl(cell, runtime);
        }
        if (TABLE_COLUMN_CLASS.equals(rubyClassName)) {
            Column column2 = RubyUtils.rubyToJava(runtime, rubyObject, Column.class);
            return new ColumnImpl(column2, runtime);
        }
        throw new IllegalArgumentException("Don't know what to do with a " + rubyObject);
    }
}

