/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.log.internal;

import java.util.Objects;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.ast.impl.CursorImpl;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaLogger
extends RubyObject {
    private final LogHandler rootLogHandler;
    private static final String LOG_PROPERTY_SOURCE_LOCATION = "source_location";
    private static final String LOG_PROPERTY_TEXT = "text";

    public static void install(Ruby runtime, final LogHandler logHandler) {
        RubyModule asciidoctorModule = runtime.getModule("Asciidoctor");
        RubyModule loggerManager = asciidoctorModule.defineOrGetModuleUnder("LoggerManager");
        RubyClass loggerBaseClass = asciidoctorModule.getClass("Logger");
        RubyClass loggerClass = asciidoctorModule.defineOrGetModuleUnder("LoggerManager").defineClassUnder("JavaLogger", loggerBaseClass, new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new JavaLogger(runtime, klazz, logHandler);
            }
        });
        loggerClass.defineAnnotatedMethods(JavaLogger.class);
        IRubyObject logger = loggerClass.allocate();
        logger.callMethod(runtime.getCurrentContext(), "initialize", runtime.getNil());
        loggerManager.callMethod("logger=", logger);
    }

    private JavaLogger(Ruby runtime, RubyClass metaClass, LogHandler rootLogHandler) {
        super(runtime, metaClass);
        this.rootLogHandler = rootLogHandler;
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=2)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] args2) {
        return Helpers.invokeSuper(threadContext, (IRubyObject)this, (RubyModule)this.getMetaClass(), "initialize", args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"add"}, required=1, optional=2)
    public IRubyObject add(ThreadContext threadContext, IRubyObject[] args2, Block block) {
        IRubyObject rubyMessage = args2.length >= 2 && !args2[1].isNil() ? args2[1] : (block.isGiven() ? block.yield(threadContext, this.getRuntime().getNil()) : args2[2]);
        Cursor cursor = this.getSourceLocation(rubyMessage);
        String message2 = this.formatMessage(rubyMessage);
        Severity severity = this.mapRubyLogLevel(args2[0]);
        LogRecord record = this.createLogRecord(threadContext, severity, cursor, message2);
        this.rootLogHandler.log(record);
        return this.getRuntime().getNil();
    }

    private LogRecord createLogRecord(ThreadContext threadContext, Severity severity, Cursor cursor, String message2) {
        BacktraceElement[] backtrace2 = threadContext.getBacktrace();
        String sourceFileName = backtrace2[2].getFilename();
        String sourceMethodName = backtrace2[2].getMethod();
        LogRecord record = new LogRecord(severity, cursor, message2, sourceFileName, sourceMethodName);
        return record;
    }

    private Severity mapRubyLogLevel(IRubyObject arg2) {
        int rubyId = arg2.convertToInteger().getIntValue();
        for (Severity severity : Severity.values()) {
            if (severity.getRubyId() != rubyId) continue;
            return severity;
        }
        return Severity.UNKNOWN;
    }

    private String formatMessage(IRubyObject msg) {
        if (this.getRuntime().getString().equals(msg.getType())) {
            return msg.asJavaString();
        }
        if (this.getRuntime().getHash().equals(msg.getType())) {
            RubyHash hash2 = (RubyHash)msg;
            return Objects.toString(hash2.get(this.getRuntime().newSymbol(LOG_PROPERTY_TEXT)));
        }
        throw new IllegalArgumentException(Objects.toString(msg));
    }

    private Cursor getSourceLocation(IRubyObject msg) {
        if (this.getRuntime().getHash().equals(msg.getType())) {
            RubyHash hash2 = (RubyHash)msg;
            Object sourceLocation = hash2.get(this.getRuntime().newSymbol(LOG_PROPERTY_SOURCE_LOCATION));
            return new CursorImpl((IRubyObject)sourceLocation);
        }
        return null;
    }
}

