/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoc.maven;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.asciidoc.maven.AsciidoctorMojo;
import org.asciidoc.maven.Synchronization;
import org.asciidoctor.Asciidoctor;

@Mojo(name="auto-refresh")
public class AsciidoctorRefreshMojo
extends AsciidoctorMojo {
    @Parameter(property="port", required=false)
    protected int port = 2000;
    @Parameter(property="interval", required=false)
    protected int interval = 2000;
    private Future<Asciidoctor> asciidoctor = null;
    private Collection<FileAlterationMonitor> monitors = null;
    private final AtomicBoolean needsUpdate = new AtomicBoolean(false);
    private ScheduledExecutorService updaterScheduler = null;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.createAsciidoctor();
        this.startPolling();
        this.startUpdater();
        this.doWork();
        this.stopUpdater();
        this.stopMonitor();
    }

    private void stopUpdater() {
        if (this.updaterScheduler != null) {
            this.updaterScheduler.shutdown();
        }
    }

    private void startUpdater() {
        this.updaterScheduler = Executors.newScheduledThreadPool(1);
        this.updaterScheduler.scheduleAtFixedRate(new Updater(this.needsUpdate, this), 0L, Math.min(1000, Math.max(200, this.interval / 2)), TimeUnit.MILLISECONDS);
    }

    protected void doWork() throws MojoFailureException, MojoExecutionException {
        this.getLog().info((CharSequence)("Rendered doc in " + this.executeAndReturnDuration() + "ms"));
        this.doWait();
    }

    protected void doWait() {
        String line;
        this.getLog().info((CharSequence)"Type [exit|quit] to exit and [refresh] to force a manual re-rendering.");
        Scanner scanner = new Scanner(System.in);
        while ((line = scanner.nextLine()) != null && !"exit".equalsIgnoreCase(line = line.trim()) && !"quit".equalsIgnoreCase(line)) {
            if ("refresh".equalsIgnoreCase(line)) {
                this.doExecute();
                continue;
            }
            this.getLog().warn((CharSequence)("'" + line + "' not understood, available commands are [quit, exit, refresh]."));
        }
    }

    private void stopMonitor() throws MojoExecutionException {
        if (this.monitors != null) {
            for (FileAlterationMonitor monitor : this.monitors) {
                try {
                    monitor.stop();
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
        }
    }

    protected synchronized void doExecute() {
        this.ensureOutputExists();
        for (File f : FileUtils.listFiles((File)this.outputDirectory, (IOFileFilter)new RegexFileFilter(".*\\.a((sc(iidoc)?)|d(oc)?)$"), (IOFileFilter)TrueFileFilter.INSTANCE)) {
            FileUtils.deleteQuietly((File)f);
        }
        try {
            this.getLog().info((CharSequence)("Re-rendered doc in " + this.executeAndReturnDuration() + "ms"));
        }
        catch (MojoExecutionException e) {
            this.getLog().error((Throwable)e);
        }
        catch (MojoFailureException e) {
            this.getLog().error((Throwable)e);
        }
    }

    protected long executeAndReturnDuration() throws MojoExecutionException, MojoFailureException {
        long start = System.nanoTime();
        super.execute();
        long end = System.nanoTime();
        return TimeUnit.NANOSECONDS.toMillis(end - start);
    }

    private void startPolling() throws MojoExecutionException {
        FileAlterationObserver observer;
        this.monitors = new ArrayList<FileAlterationMonitor>();
        if (this.sourceDirectory != null) {
            observer = new FileAlterationObserver(this.sourceDirectory, (FileFilter)new RegexFileFilter(".*\\.a((sc(iidoc)?)|d(oc)?)$"));
        } else if (this.sourceDocumentName != null) {
            observer = new FileAlterationObserver(this.sourceDocumentName.getParentFile(), (FileFilter)new NameFileFilter(this.sourceDocumentName.getName()));
        } else {
            this.monitors = null;
            return;
        }
        FileAlterationMonitor monitor3 = new FileAlterationMonitor((long)this.interval);
        FileAlterationListenerAdaptor listener = new FileAlterationListenerAdaptor(){

            public void onFileCreate(File file) {
                AsciidoctorRefreshMojo.this.getLog().info((CharSequence)("File " + file.getAbsolutePath() + " created."));
                AsciidoctorRefreshMojo.this.needsUpdate.set(true);
            }

            public void onFileChange(File file) {
                AsciidoctorRefreshMojo.this.getLog().info((CharSequence)("File " + file.getAbsolutePath() + " updated."));
                AsciidoctorRefreshMojo.this.needsUpdate.set(true);
            }

            public void onFileDelete(File file) {
                AsciidoctorRefreshMojo.this.getLog().info((CharSequence)("File " + file.getAbsolutePath() + " deleted."));
                AsciidoctorRefreshMojo.this.needsUpdate.set(true);
            }
        };
        observer.addListener((FileAlterationListener)listener);
        monitor3.addObserver(observer);
        this.monitors.add(monitor3);
        if (this.synchronizations != null) {
            for (final Synchronization s : this.synchronizations) {
                FileAlterationMonitor monitor2 = new FileAlterationMonitor((long)this.interval);
                FileAlterationListenerAdaptor listener2 = new FileAlterationListenerAdaptor(){

                    public void onFileCreate(File file) {
                        AsciidoctorRefreshMojo.this.getLog().info((CharSequence)("File " + file.getAbsolutePath() + " created."));
                        AsciidoctorRefreshMojo.this.synchronize(s);
                        AsciidoctorRefreshMojo.this.needsUpdate.set(true);
                    }

                    public void onFileChange(File file) {
                        AsciidoctorRefreshMojo.this.getLog().info((CharSequence)("File " + file.getAbsolutePath() + " updated."));
                        AsciidoctorRefreshMojo.this.synchronize(s);
                        AsciidoctorRefreshMojo.this.needsUpdate.set(true);
                    }

                    public void onFileDelete(File file) {
                        AsciidoctorRefreshMojo.this.getLog().info((CharSequence)("File " + file.getAbsolutePath() + " deleted."));
                        FileUtils.deleteQuietly((File)file);
                        AsciidoctorRefreshMojo.this.needsUpdate.set(true);
                    }
                };
                File source = s.getSource();
                FileAlterationObserver observer2 = source.isDirectory() ? new FileAlterationObserver(source) : new FileAlterationObserver(source.getParentFile(), (FileFilter)new NameFileFilter(source.getName()));
                observer2.addListener((FileAlterationListener)listener2);
                monitor2.addObserver(observer2);
                this.monitors.add(monitor2);
            }
        }
        for (FileAlterationMonitor monitor3 : this.monitors) {
            try {
                monitor3.start();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private void createAsciidoctor() {
        ExecutorService es = Executors.newSingleThreadExecutor();
        this.asciidoctor = es.submit(new Callable<Asciidoctor>(){

            @Override
            public Asciidoctor call() throws Exception {
                return Asciidoctor.Factory.create();
            }
        });
        es.shutdown();
    }

    @Override
    protected Asciidoctor getAsciidoctorInstance() throws MojoExecutionException {
        try {
            return this.asciidoctor.get();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private static class Updater
    implements Runnable {
        private final AtomicBoolean run;
        private final AsciidoctorRefreshMojo mojo;

        private Updater(AtomicBoolean run, AsciidoctorRefreshMojo mojo) {
            this.run = run;
            this.mojo = mojo;
        }

        @Override
        public void run() {
            if (this.run.get()) {
                this.run.set(false);
                this.mojo.doExecute();
            }
        }
    }
}

