/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site;

import java.util.Optional;
import org.asciidoctor.log.Severity;
import org.asciidoctor.maven.log.FailIf;
import org.asciidoctor.maven.log.LogHandler;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class SiteLogHandlerDeserializer {
    public static final String NODE_NAME = "logHandler";

    public LogHandler deserialize(Xpp3Dom configNode) {
        LogHandler logHandler = this.defaultLogHandler();
        if (configNode == null) {
            return logHandler;
        }
        Xpp3Dom logHandlerNode = configNode.getChild(NODE_NAME);
        if (logHandlerNode == null || !logHandlerNode.getName().equals(NODE_NAME)) {
            return logHandler;
        }
        logHandler.setOutputToConsole(this.deserializeOutputToConsole(logHandlerNode));
        this.deserializeFailIf(logHandlerNode.getChild("failIf")).ifPresent(logHandler::setFailIf);
        return logHandler;
    }

    private Boolean deserializeOutputToConsole(Xpp3Dom node) {
        return this.getBoolean(node, "outputToConsole");
    }

    private Optional<FailIf> deserializeFailIf(Xpp3Dom node) {
        String sanitizedContainsText;
        Xpp3Dom containsText;
        String sanitizedSeverity;
        if (node == null) {
            return Optional.empty();
        }
        Xpp3Dom severity = node.getChild("severity");
        FailIf failIf = null;
        if (severity != null && (sanitizedSeverity = this.sanitizeString(severity)).length() > 0) {
            Severity severityEnumValue = Severity.valueOf((String)sanitizedSeverity);
            failIf = new FailIf();
            failIf.setSeverity(severityEnumValue);
        }
        if ((containsText = node.getChild("containsText")) != null && (sanitizedContainsText = this.sanitizeString(containsText)).length() > 0) {
            failIf = failIf == null ? new FailIf() : failIf;
            failIf.setContainsText(sanitizedContainsText);
        }
        return Optional.ofNullable(failIf);
    }

    private String sanitizeString(Xpp3Dom severity) {
        String value = severity.getValue();
        return value == null ? "" : value.trim();
    }

    private LogHandler defaultLogHandler() {
        LogHandler logHandler = new LogHandler();
        logHandler.setOutputToConsole(Boolean.TRUE);
        return logHandler;
    }

    private Boolean getBoolean(Xpp3Dom node, String name) {
        Xpp3Dom child = node.getChild(name);
        if (child == null) {
            return Boolean.TRUE;
        }
        if (child.getValue() == null) {
            return Boolean.TRUE;
        }
        return Boolean.valueOf(child.getValue());
    }
}

