/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.axonframework.common.jdbc.JdbcException;

public class JdbcUtils {
    public static <R> R executeQuery(Connection connection, SqlFunction sqlFunction, SqlResultConverter<R> sqlResultConverter, Function<SQLException, RuntimeException> errorHandler) {
        return JdbcUtils.executeQuery(connection, sqlFunction, sqlResultConverter, errorHandler, true);
    }

    /*
     * Exception decompiling
     */
    public static <R> R executeQuery(Connection connection, SqlFunction sqlFunction, SqlResultConverter<R> sqlResultConverter, Function<SQLException, RuntimeException> errorHandler, boolean closeConnection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int executeUpdate(Connection connection, SqlFunction updateFunction, Function<SQLException, RuntimeException> errorHandler) {
        PreparedStatement preparedStatement = JdbcUtils.createSqlStatement(connection, updateFunction);
        try {
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw errorHandler.apply(e);
        }
        finally {
            JdbcUtils.closeQuietly(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeUpdates(Connection connection, Consumer<SQLException> errorHandler, SqlFunction ... sqlFunctions) {
        try {
            int[] result = new int[sqlFunctions.length];
            IntStream.range(0, sqlFunctions.length).forEach(i -> {
                SqlFunction sqlFunction = sqlFunctions[i];
                PreparedStatement preparedStatement = JdbcUtils.createSqlStatement(connection, sqlFunction);
                try {
                    result[i] = preparedStatement.executeUpdate();
                }
                catch (SQLException e) {
                    errorHandler.accept(e);
                }
                finally {
                    JdbcUtils.closeQuietly(preparedStatement);
                }
            });
            int[] nArray = result;
            return nArray;
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeBatch(Connection connection, SqlFunction sqlFunction, Consumer<SQLException> errorHandler) {
        block9: {
            try {
                int[] nArray;
                PreparedStatement preparedStatement = JdbcUtils.createSqlStatement(connection, sqlFunction);
                try {
                    nArray = preparedStatement.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        errorHandler.accept(e);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        JdbcUtils.closeQuietly(preparedStatement);
                    }
                }
                JdbcUtils.closeQuietly(preparedStatement);
                return nArray;
            }
            finally {
                JdbcUtils.closeQuietly(connection);
            }
        }
        return new int[0];
    }

    public static <R> SqlResultConverter<List<R>> listResults(SqlResultConverter<R> singleResultConverter) {
        return resultSet -> {
            ArrayList results = new ArrayList();
            while (resultSet.next()) {
                results.add(singleResultConverter.apply(resultSet));
            }
            return results;
        };
    }

    public static void closeQuietly(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static PreparedStatement createSqlStatement(Connection connection, SqlFunction sqlFunction) {
        try {
            return sqlFunction.apply(connection);
        }
        catch (SQLException e) {
            throw new JdbcException("Failed to create a SQL statement", e);
        }
    }

    public static <T> T nextAndExtract(ResultSet resultSet, int column, Class<T> columnType) throws SQLException, NullPointerException {
        return JdbcUtils.nextAndExtract(resultSet, column, columnType, null);
    }

    public static <T> T nextAndExtract(ResultSet resultSet, int column, Class<T> columnType, T defaultValue) throws SQLException, NullPointerException {
        return resultSet.next() ? JdbcUtils.extract(resultSet, column, columnType, defaultValue) : defaultValue;
    }

    public static <T> T extract(ResultSet resultSet, int column, Class<T> columnType) throws SQLException, NullPointerException {
        return JdbcUtils.extract(resultSet, column, columnType, null);
    }

    public static <T> T extract(ResultSet resultSet, int column, Class<T> columnType, T defaultValue) throws SQLException, NullPointerException {
        T value = resultSet.getObject(column, columnType);
        return value == null || resultSet.wasNull() ? defaultValue : value;
    }

    private JdbcUtils() {
    }

    @FunctionalInterface
    public static interface SqlResultConverter<R> {
        public R apply(ResultSet var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface SqlFunction {
        public PreparedStatement apply(Connection var1) throws SQLException;
    }
}

