/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.dbscheduler;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

public class DbSchedulerBinaryDeadlineDetails
implements Serializable {
    private String d;
    private byte[] s;
    private String sc;
    private byte[] p;
    private String pc;
    private String r;
    private byte[] m;

    DbSchedulerBinaryDeadlineDetails() {
    }

    public DbSchedulerBinaryDeadlineDetails(@Nonnull String deadlineName, @Nonnull byte[] scopeDescriptor, @Nonnull String scopeDescriptorClass, @Nullable byte[] payload, @Nullable String payloadClass, @Nullable String payloadRevision, @Nullable byte[] metaData) {
        this.d = deadlineName;
        this.s = scopeDescriptor;
        this.sc = scopeDescriptorClass;
        this.p = payload;
        this.pc = payloadClass;
        this.r = payloadRevision;
        this.m = metaData;
    }

    static DbSchedulerBinaryDeadlineDetails serialized(@Nonnull String deadlineName, @Nonnull ScopeDescriptor descriptor, @Nonnull DeadlineMessage message, @Nonnull Serializer serializer) {
        SerializedObject<byte[]> serializedDescriptor = serializer.serialize(descriptor, byte[].class);
        SerializedObject<byte[]> serializedPayload = serializer.serialize(message.getPayload(), byte[].class);
        SerializedObject<byte[]> serializedMetaData = serializer.serialize(message.getMetaData(), byte[].class);
        return new DbSchedulerBinaryDeadlineDetails(deadlineName, serializedDescriptor.getData(), serializedDescriptor.getType().getName(), serializedPayload.getData(), serializedPayload.getType().getName(), serializedPayload.getType().getRevision(), serializedMetaData.getData());
    }

    public String getD() {
        return this.d;
    }

    public byte[] getS() {
        return this.s;
    }

    public String getSc() {
        return this.sc;
    }

    public byte[] getP() {
        return this.p;
    }

    public String getPc() {
        return this.pc;
    }

    public String getR() {
        return this.r;
    }

    public byte[] getM() {
        return this.m;
    }

    public GenericDeadlineMessage asDeadLineMessage(Serializer serializer) {
        return new GenericDeadlineMessage<Object>(this.d, this.getDeserializedPayload(serializer), this.getDeserializedMetaData(serializer));
    }

    private Object getDeserializedPayload(Serializer serializer) {
        SimpleSerializedObject<byte[]> serializedDeadlinePayload = new SimpleSerializedObject<byte[]>(this.p, byte[].class, this.pc, this.r);
        return serializer.deserialize(serializedDeadlinePayload);
    }

    private MetaData getDeserializedMetaData(Serializer serializer) {
        SimpleSerializedObject<byte[]> serializedDeadlineMetaData = new SimpleSerializedObject<byte[]>(this.m, byte[].class, MetaData.class.getName(), null);
        return (MetaData)serializer.deserialize(serializedDeadlineMetaData);
    }

    public ScopeDescriptor getDeserializedScopeDescriptor(Serializer serializer) {
        SimpleSerializedObject<byte[]> serializedDeadlineScope = new SimpleSerializedObject<byte[]>(this.s, byte[].class, this.sc, null);
        return (ScopeDescriptor)serializer.deserialize(serializedDeadlineScope);
    }

    public String toString() {
        return String.format("DbScheduler deadline details, deadlineName: [%s], scopeDescriptor: [%s], scopeDescriptorClass: [%s], payload: [%s], payloadClass: [%s], payloadRevision: [%s], metadata: [%s]", this.d, Arrays.toString(this.s), this.sc, Arrays.toString(this.p), this.pc, this.r, Arrays.toString(this.m));
    }

    public int hashCode() {
        return Objects.hash(this.d, Arrays.hashCode(this.s), this.sc, Arrays.hashCode(this.p), this.pc, this.r, Arrays.hashCode(this.m));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DbSchedulerBinaryDeadlineDetails other = (DbSchedulerBinaryDeadlineDetails)obj;
        return Objects.equals(this.d, other.d) && Arrays.equals(this.s, other.s) && Objects.equals(this.sc, other.sc) && Arrays.equals(this.p, other.p) && Objects.equals(this.pc, other.pc) && Objects.equals(this.r, other.r) && Arrays.equals(this.m, other.m);
    }
}

