/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;

public class GenericDomainEventMessage<T>
extends GenericEventMessage<T>
implements DomainEventMessage<T> {
    private static final long serialVersionUID = -1222000190977419970L;
    private final String type;
    private final String aggregateIdentifier;
    private final long sequenceNumber;

    public GenericDomainEventMessage(String type, String aggregateIdentifier, long sequenceNumber, T payload) {
        this(type, aggregateIdentifier, sequenceNumber, payload, MetaData.emptyInstance());
    }

    public GenericDomainEventMessage(String type, String aggregateIdentifier, long sequenceNumber, T payload, Map<String, ?> metaData) {
        this(type, aggregateIdentifier, sequenceNumber, new GenericMessage<T>(payload, metaData), clock.instant());
    }

    public GenericDomainEventMessage(String type, String aggregateIdentifier, long sequenceNumber, T payload, Map<String, ?> metaData, String messageIdentifier, Instant timestamp) {
        this(type, aggregateIdentifier, sequenceNumber, new GenericMessage<T>(messageIdentifier, payload, metaData), timestamp);
    }

    public GenericDomainEventMessage(String type, String aggregateIdentifier, long sequenceNumber, Message<T> delegate, Supplier<Instant> timestamp) {
        super(delegate, timestamp);
        this.type = type;
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
    }

    public GenericDomainEventMessage(String type, String aggregateIdentifier, long sequenceNumber, Message<T> delegate, Instant timestamp) {
        super(delegate, timestamp);
        this.type = type;
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public GenericDomainEventMessage<T> withMetaData(@Nonnull Map<String, ?> metaData) {
        if (this.getMetaData().equals(metaData)) {
            return this;
        }
        return new GenericDomainEventMessage(this.type, this.aggregateIdentifier, this.sequenceNumber, this.getDelegate().withMetaData(metaData), this.getTimestamp());
    }

    @Override
    public GenericDomainEventMessage<T> andMetaData(@Nonnull Map<String, ?> metaData) {
        if (metaData == null || metaData.isEmpty() || this.getMetaData().equals(metaData)) {
            return this;
        }
        return new GenericDomainEventMessage(this.type, this.aggregateIdentifier, this.sequenceNumber, this.getDelegate().andMetaData(metaData), this.getTimestamp());
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append('\'').append(", aggregateType='").append(this.getType()).append('\'').append(", aggregateIdentifier='").append(this.getAggregateIdentifier()).append('\'').append(", sequenceNumber=").append(this.getSequenceNumber());
    }

    @Override
    protected String describeType() {
        return "GenericDomainEventMessage";
    }
}

