/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterSchema;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterTableFactory;

public class GenericDeadLetterTableFactory
implements DeadLetterTableFactory {
    @Override
    public Statement createTableStatement(Connection connection, DeadLetterSchema schema) throws SQLException {
        Statement statement = connection.createStatement();
        statement.addBatch(this.createTableSql(schema));
        statement.addBatch(this.processingGroupIndexSql(schema));
        statement.addBatch(this.sequenceIdentifierIndexSql(schema));
        return statement;
    }

    protected String createTableSql(DeadLetterSchema schema) {
        return "CREATE TABLE IF NOT EXISTS " + schema.deadLetterTable() + " (\n" + schema.deadLetterIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.processingGroupColumn() + " VARCHAR(255) NOT NULL,\n" + schema.sequenceIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.sequenceIndexColumn() + " BIGINT NOT NULL,\n" + schema.messageTypeColumn() + " VARCHAR(255) NOT NULL,\n" + schema.eventIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.timestampColumn() + " " + this.timestampType() + " NOT NULL,\n" + schema.payloadTypeColumn() + " VARCHAR(255) NOT NULL,\n" + schema.payloadRevisionColumn() + " VARCHAR(255),\n" + schema.payloadColumn() + " " + this.serializedDataType() + " NOT NULL,\n" + schema.metaDataColumn() + " " + this.serializedDataType() + ",\n" + schema.aggregateTypeColumn() + " VARCHAR(255),\n" + schema.aggregateIdentifierColumn() + " VARCHAR(255),\n" + schema.sequenceNumberColumn() + " BIGINT,\n" + schema.tokenTypeColumn() + " VARCHAR(255),\n" + schema.tokenColumn() + " " + this.serializedDataType() + ",\n" + schema.enqueuedAtColumn() + " " + this.timestampType() + " NOT NULL,\n" + schema.lastTouchedColumn() + " " + this.timestampType() + ",\n" + schema.processingStartedColumn() + " " + this.timestampType() + ",\n" + schema.causeTypeColumn() + " VARCHAR(255),\n" + schema.causeMessageColumn() + " VARCHAR(1023),\n" + schema.diagnosticsColumn() + " " + this.serializedDataType() + ",\nCONSTRAINT PK PRIMARY KEY (" + schema.deadLetterIdentifierColumn() + "),\nCONSTRAINT " + schema.sequenceIndexColumn() + "_INDEX UNIQUE (" + schema.processingGroupColumn() + "," + schema.sequenceIdentifierColumn() + "," + schema.sequenceIndexColumn() + ")\n)";
    }

    protected String processingGroupIndexSql(DeadLetterSchema schema) {
        return "CREATE INDEX " + schema.processingGroupColumn() + "_INDEX ON " + schema.deadLetterTable() + " (" + schema.processingGroupColumn() + ")";
    }

    protected String sequenceIdentifierIndexSql(DeadLetterSchema schema) {
        return "CREATE INDEX " + schema.sequenceIdentifierColumn() + "_INDEX ON " + schema.deadLetterTable() + " (" + schema.processingGroupColumn() + "," + schema.sequenceIdentifierColumn() + ")";
    }

    protected String serializedDataType() {
        return "BLOB";
    }

    protected String timestampType() {
        return "VARCHAR(255)";
    }
}

