/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.responsetypes;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.axonframework.messaging.responsetypes.AbstractResponseType;
import org.axonframework.messaging.responsetypes.MultipleInstancesResponseType;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PublisherResponseType<R>
extends AbstractResponseType<Publisher<R>> {
    public static final int PUBLISHER_MATCH = 2048;
    private final ResponseType<?> multipleInstanceResponseType;

    public PublisherResponseType(Class<?> expectedResponseType) {
        super(expectedResponseType);
        this.multipleInstanceResponseType = new MultipleInstancesResponseType(expectedResponseType);
    }

    @Override
    public boolean matches(Type responseType) {
        return this.matchRank(responseType) > 0;
    }

    @Override
    public Integer matchRank(Type responseType) {
        if (this.isPublisherOfExpectedType(responseType)) {
            return 2048;
        }
        return this.multipleInstanceResponseType.matchRank(responseType);
    }

    @Override
    public Class responseMessagePayloadType() {
        return Flux.class;
    }

    @Override
    public Publisher<R> convert(Object queryResponse) {
        if (!this.projectReactorOnClassPath()) {
            return null;
        }
        if (queryResponse == null) {
            return Flux.empty();
        }
        if (Publisher.class.isAssignableFrom(queryResponse.getClass())) {
            return Flux.from((Publisher)((Publisher)queryResponse));
        }
        if (Iterable.class.isAssignableFrom(queryResponse.getClass())) {
            return Flux.fromIterable((Iterable)((Iterable)queryResponse));
        }
        if (Stream.class.isAssignableFrom(queryResponse.getClass())) {
            return Flux.fromStream((Stream)((Stream)queryResponse));
        }
        if (CompletableFuture.class.isAssignableFrom(queryResponse.getClass())) {
            return Flux.from((Publisher)Mono.fromCompletionStage((CompletionStage)((CompletableFuture)queryResponse)));
        }
        if (Optional.class.isAssignableFrom(queryResponse.getClass())) {
            return (Flux)((Optional)queryResponse).map(Flux::just).orElse(Flux.empty());
        }
        return Flux.just((Object)queryResponse);
    }

    @Override
    public Optional<Publisher<R>> convertExceptional(Throwable e) {
        return Optional.of(Flux.error((Throwable)e));
    }

    @Override
    public ResponseType<?> forSerialization() {
        return ResponseTypes.multipleInstancesOf(this.expectedResponseType);
    }
}

