/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.axonframework.eventhandling.GapAwareTrackingToken;

public final class GapAwareTrackingTokenConverter
extends CollectionConverter {
    private static final String GAP_AWARE_TRACKING_TOKEN = "org.axonframework.eventhandling.GapAwareTrackingToken";
    private static final String LEGACY_GAP_AWARE_TRACKING_TOKEN = "org.axonframework.eventsourcing.eventstore.GapAwareTrackingToken";
    private static final String INDEX_NODE = "index";
    private static final String GAPS_NODE = "gaps";
    private final ReflectivelyConstructedGapSetConverter reflectivelyConstructedGapSetConverter;

    public GapAwareTrackingTokenConverter(Mapper mapper) {
        super(mapper);
        this.reflectivelyConstructedGapSetConverter = new ReflectivelyConstructedGapSetConverter(mapper);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        GapAwareTrackingToken token = (GapAwareTrackingToken)source;
        writer.startNode(INDEX_NODE);
        writer.setValue(String.valueOf(token.getIndex()));
        writer.endNode();
        writer.startNode(GAPS_NODE);
        SortedSet<Long> gaps = token.getGaps();
        for (Long gap : gaps) {
            this.writeCompleteItem(gap, context, writer);
        }
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TreeSet gaps;
        reader.moveDown();
        Long index = Long.valueOf(reader.getValue());
        reader.moveUp();
        reader.moveDown();
        if (GapAwareTrackingTokenConverter.doesNotHaveClassAttribute(reader)) {
            gaps = (TreeSet)this.createCollection(TreeSet.class);
            this.populateCollection(reader, context, gaps);
        } else {
            gaps = (TreeSet)this.reflectivelyConstructedGapSetConverter.unmarshal(reader, context);
        }
        reader.moveUp();
        return new GapAwareTrackingToken(index, gaps);
    }

    private static boolean doesNotHaveClassAttribute(HierarchicalStreamReader reader) {
        return reader.getAttribute("class") == null;
    }

    public boolean canConvert(Class type) {
        return GAP_AWARE_TRACKING_TOKEN.equals(type.getName()) || LEGACY_GAP_AWARE_TRACKING_TOKEN.equals(type.getName());
    }

    private static final class ReflectivelyConstructedGapSetConverter
    extends CollectionConverter {
        private static final String DEFAULT_NODE = "default";
        private static final String NULL_NODE = "null";

        ReflectivelyConstructedGapSetConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            throw new UnsupportedOperationException("This converter is only intended to directly unmarshal a reflectively constructed GapAwareTrackingToken gaps collections");
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            throw new UnsupportedOperationException("This converter is only intended to directly unmarshal a reflectively constructed GapAwareTrackingToken gaps collections");
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Set gaps = (Set)this.createCollection(TreeSet.class);
            reader.moveDown();
            reader.moveDown();
            reader.moveUp();
            reader.moveDown();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (ReflectivelyConstructedGapSetConverter.readingDefaultOrNullNode(reader.getNodeName()) || ReflectivelyConstructedGapSetConverter.readingBooleanNode(reader.getValue())) {
                    reader.moveUp();
                    continue;
                }
                gaps.add(Long.valueOf(reader.getValue()));
                reader.moveUp();
            }
            reader.moveUp();
            reader.moveUp();
            return gaps;
        }

        private static boolean readingDefaultOrNullNode(String nodeName) {
            return DEFAULT_NODE.equals(nodeName) || NULL_NODE.equals(nodeName);
        }

        private static boolean readingBooleanNode(String value) {
            return Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value);
        }
    }
}

