/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.provider.KeyStoreConfig;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvX509KeyManager;
import org.bouncycastle.jsse.provider.ProvX509KeyManagerSimple;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    private static final Logger LOG = Logger.getLogger(ProvKeyManagerFactorySpi.class.getName());
    protected final boolean fipsMode;
    protected final JcaJceHelper helper;
    protected BCX509ExtendedKeyManager x509KeyManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStoreConfig getDefaultKeyStore() throws Exception {
        String defaultType = KeyStore.getDefaultType();
        String ksPath = null;
        char[] ksPassword = null;
        String ksPathProp = PropertyUtils.getStringSystemProperty("javax.net.ssl.keyStore");
        if (!"NONE".equals(ksPathProp) && null != ksPathProp && new File(ksPathProp).exists()) {
            ksPath = ksPathProp;
        }
        KeyStore ks = ProvKeyManagerFactorySpi.createKeyStore(defaultType);
        String ksPasswordProp = PropertyUtils.getSensitiveStringSystemProperty("javax.net.ssl.keyStorePassword");
        if (null != ksPasswordProp) {
            ksPassword = ksPasswordProp.toCharArray();
        }
        InputStream ksInput = null;
        try {
            if (null == ksPath) {
                LOG.config("Initializing default key store as empty");
            } else {
                LOG.config("Initializing default key store from path: " + ksPath);
                ksInput = new BufferedInputStream(new FileInputStream(ksPath));
            }
            try {
                ks.load(ksInput, ksPassword);
            }
            catch (NullPointerException e) {
                ks = KeyStore.getInstance("BCFKS");
                ks.load(null, null);
            }
        }
        finally {
            if (null != ksInput) {
                ksInput.close();
            }
        }
        return new KeyStoreConfig(ks, ksPassword);
    }

    ProvKeyManagerFactorySpi(boolean fipsMode, JcaJceHelper helper) {
        this.fipsMode = fipsMode;
        this.helper = helper;
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        if (null == this.x509KeyManager) {
            throw new IllegalStateException("KeyManagerFactory not initialized");
        }
        return new KeyManager[]{this.x509KeyManager};
    }

    @Override
    protected void engineInit(KeyStore ks, char[] ksPassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.x509KeyManager = new ProvX509KeyManagerSimple(this.fipsMode, this.helper, ks, ksPassword);
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (!(managerFactoryParameters instanceof KeyStoreBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters");
        }
        List<KeyStore.Builder> builders = ((KeyStoreBuilderParameters)managerFactoryParameters).getParameters();
        this.x509KeyManager = new ProvX509KeyManager(this.fipsMode, this.helper, builders);
    }

    private static KeyStore createKeyStore(String defaultType) throws NoSuchProviderException, KeyStoreException {
        String ksType = ProvKeyManagerFactorySpi.getKeyStoreType(defaultType);
        String ksProv = PropertyUtils.getStringSystemProperty("javax.net.ssl.keyStoreProvider");
        return TlsUtils.isNullOrEmpty(ksProv) ? KeyStore.getInstance(ksType) : KeyStore.getInstance(ksType, ksProv);
    }

    private static String getKeyStoreType(String defaultType) {
        String ksType = PropertyUtils.getStringSystemProperty("javax.net.ssl.keyStoreType");
        return null == ksType ? defaultType : ksType;
    }
}

