/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsSecret
extends AbstractTlsSecret {
    private static final byte[] SSL3_CONST = JceTlsSecret.generateSSL3Constants();
    protected final JcaTlsCrypto crypto;

    public static JceTlsSecret convert(JcaTlsCrypto crypto, TlsSecret secret) {
        if (secret instanceof JceTlsSecret) {
            return (JceTlsSecret)secret;
        }
        if (secret instanceof AbstractTlsSecret) {
            AbstractTlsSecret abstractTlsSecret = (AbstractTlsSecret)secret;
            return crypto.adoptLocalSecret(JceTlsSecret.copyData(abstractTlsSecret));
        }
        throw new IllegalArgumentException("unrecognized TlsSecret - cannot copy data: " + secret.getClass().getName());
    }

    private static byte[] generateSSL3Constants() {
        int n = 15;
        byte[] result = new byte[n * (n + 1) / 2];
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            byte b = (byte)(65 + i);
            for (int j = 0; j <= i; ++j) {
                result[pos++] = b;
            }
        }
        return result;
    }

    public JceTlsSecret(JcaTlsCrypto crypto, byte[] data) {
        super(data);
        this.crypto = crypto;
    }

    @Override
    public synchronized TlsSecret deriveUsingPRF(int prfAlgorithm, String label, byte[] seed, int length) {
        this.checkAlive();
        try {
            switch (prfAlgorithm) {
                case 4: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 4, label, seed, length);
                }
                case 5: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 5, label, seed, length);
                }
                case 7: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 7, label, seed, length);
                }
            }
            return this.crypto.adoptLocalSecret(this.prf(prfAlgorithm, label, seed, length));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FipsKDF.AgreementKDFPRF getHMACAlgorithmPrf(int hashAlgorithm) {
        switch (hashAlgorithm) {
            case 2: {
                return FipsKDF.AgreementKDFPRF.SHA1_HMAC;
            }
            case 3: {
                return FipsKDF.AgreementKDFPRF.SHA224_HMAC;
            }
            case 4: {
                return FipsKDF.AgreementKDFPRF.SHA256_HMAC;
            }
            case 5: {
                return FipsKDF.AgreementKDFPRF.SHA384_HMAC;
            }
            case 6: {
                return FipsKDF.AgreementKDFPRF.SHA512_HMAC;
            }
        }
        throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText((short)hashAlgorithm));
    }

    @Override
    public synchronized TlsSecret hkdfExpand(int cryptoHashAlgorithm, byte[] info, int length) {
        if (length < 1) {
            return this.crypto.adoptLocalSecret(TlsUtils.EMPTY_BYTES);
        }
        int hashLen = TlsCryptoUtils.getHashOutputSize(cryptoHashAlgorithm);
        if (length > 255 * hashLen) {
            throw new IllegalArgumentException("'length' must be <= 255 * (output size of 'hashAlgorithm')");
        }
        this.checkAlive();
        byte[] prk = this.data;
        byte[] okm = new byte[length];
        KDFCalculator kdfCalc = new FipsKDF.AgreementOperatorFactory().createKDFCalculator(FipsKDF.HKDF.withPRF(this.getHMACAlgorithmPrf(cryptoHashAlgorithm)).using(prk).withIV(info));
        kdfCalc.generateBytes(okm);
        return this.crypto.adoptLocalSecret(okm);
    }

    @Override
    public synchronized TlsSecret hkdfExtract(int cryptoHashAlgorithm, TlsSecret ikm) {
        this.checkAlive();
        byte[] salt = this.data;
        this.data = null;
        FipsKDF.HKDFKey prk = FipsKDF.HKDF_KEY_BUILDER.withPrf(this.getHMACAlgorithmPrf(cryptoHashAlgorithm)).withSalt(salt).build(JceTlsSecret.copyData((AbstractTlsSecret)ikm));
        return this.crypto.adoptLocalSecret(prk.getKey());
    }

    @Override
    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(int cryptoHashAlgorithm, byte[] secret, int secretOff, int secretLen, byte[] seed, byte[] output) throws GeneralSecurityException {
        String digestName = this.crypto.getDigestName(cryptoHashAlgorithm).replaceAll("-", "");
        String macName = "Hmac" + digestName;
        Mac mac = this.crypto.getHelper().createMac(macName);
        mac.init(new SecretKeySpec(secret, secretOff, secretLen, macName));
        byte[] a = seed;
        int macSize = mac.getMacLength();
        byte[] b1 = new byte[macSize];
        byte[] b2 = new byte[macSize];
        for (int pos = 0; pos < output.length; pos += macSize) {
            mac.update(a, 0, a.length);
            mac.doFinal(b1, 0);
            a = b1;
            mac.update(a, 0, a.length);
            mac.update(seed, 0, seed.length);
            mac.doFinal(b2, 0);
            System.arraycopy(b2, 0, output, pos, Math.min(macSize, output.length - pos));
        }
    }

    protected byte[] prf(int prfAlgorithm, String label, byte[] seed, int length) throws GeneralSecurityException {
        KDFCalculator calculator;
        if (0 == prfAlgorithm) {
            return this.prf_SSL(seed, length);
        }
        if (prfAlgorithm == 1) {
            calculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_1.using(this.data, label, (byte[][])new byte[][]{seed}));
        } else if (prfAlgorithm == 2) {
            calculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_2.withPRF(FipsKDF.TLSPRF.SHA256_HMAC).using(this.data, label, (byte[][])new byte[][]{seed}));
        } else if (prfAlgorithm == 3) {
            calculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_2.withPRF(FipsKDF.TLSPRF.SHA384_HMAC).using(this.data, label, (byte[][])new byte[][]{seed}));
        } else {
            throw new IllegalStateException("unknown prf: " + prfAlgorithm);
        }
        byte[] result = new byte[length];
        calculator.generateBytes(result);
        return result;
    }

    protected byte[] prf_SSL(byte[] seed, int length) throws GeneralSecurityException {
        MessageDigest md5 = this.crypto.getHelper().createDigest("MD5");
        MessageDigest sha1 = this.crypto.getHelper().createDigest("SHA-1");
        int md5Size = md5.getDigestLength();
        int sha1Size = sha1.getDigestLength();
        byte[] tmp = new byte[Math.max(md5Size, sha1Size)];
        byte[] result = new byte[length];
        int constLen = 1;
        int constPos = 0;
        int resultPos = 0;
        while (resultPos < length) {
            sha1.update(SSL3_CONST, constPos, constLen);
            constPos += constLen++;
            sha1.update(this.data, 0, this.data.length);
            sha1.update(seed, 0, seed.length);
            sha1.digest(tmp, 0, sha1Size);
            md5.update(this.data, 0, this.data.length);
            md5.update(tmp, 0, sha1Size);
            int remaining = length - resultPos;
            if (remaining < md5Size) {
                md5.digest(tmp, 0, md5Size);
                System.arraycopy(tmp, 0, result, resultPos, remaining);
                resultPos += remaining;
                continue;
            }
            md5.digest(result, resultPos, md5Size);
            resultPos += md5Size;
        }
        return result;
    }

    protected synchronized void updateMac(Mac mac) {
        this.checkAlive();
        mac.update(this.data, 0, this.data.length);
    }
}

