/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bouncycastle.jsse.provider.AlgorithmDecomposer;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class JcaAlgorithmDecomposer
implements AlgorithmDecomposer {
    private static final Map<String, String> SHA_DIGEST_MAP = JcaAlgorithmDecomposer.createSHADigestMap();
    private static final Pattern PATTERN = Pattern.compile("with|and|(?<!padd)in", 2);
    static final JcaAlgorithmDecomposer INSTANCE_JCA = new JcaAlgorithmDecomposer();

    JcaAlgorithmDecomposer() {
    }

    @Override
    public Set<String> decompose(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (JsseUtils.isNameSpecified(string)) {
            JcaAlgorithmDecomposer.implDecompose(hashSet, string);
            if (string.contains("SHA")) {
                for (Map.Entry<String, String> entry : SHA_DIGEST_MAP.entrySet()) {
                    JcaAlgorithmDecomposer.includeBothIfEither(hashSet, entry.getKey(), entry.getValue());
                }
            }
        }
        return hashSet;
    }

    static String decomposeDigestName(String string) {
        String string2 = SHA_DIGEST_MAP.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    static Set<String> decomposeName(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (JsseUtils.isNameSpecified(string)) {
            JcaAlgorithmDecomposer.implDecompose(hashSet, string);
            if (string.contains("SHA")) {
                for (Map.Entry<String, String> entry : SHA_DIGEST_MAP.entrySet()) {
                    JcaAlgorithmDecomposer.replaceFirstWithSecond(hashSet, entry.getKey(), entry.getValue());
                }
            }
        }
        return hashSet;
    }

    private static Map<String, String> createSHADigestMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SHA-1", "SHA1");
        hashMap.put("SHA-224", "SHA224");
        hashMap.put("SHA-256", "SHA256");
        hashMap.put("SHA-384", "SHA384");
        hashMap.put("SHA-512", "SHA512");
        hashMap.put("SHA-512/224", "SHA512/224");
        hashMap.put("SHA-512/256", "SHA512/256");
        return hashMap;
    }

    private static void implDecompose(Set<String> set, String string) {
        for (String string2 : string.split("/")) {
            if (string2.length() <= 0) continue;
            for (String string3 : PATTERN.split(string2)) {
                if (string3.length() <= 0) continue;
                set.add(string3);
            }
        }
    }

    private static void includeBothIfEither(Set<String> set, String string, String string2) {
        if (set.contains(string)) {
            set.add(string2);
        } else if (set.contains(string2)) {
            set.add(string);
        }
    }

    private static void replaceFirstWithSecond(Set<String> set, String string, String string2) {
        if (set.remove(string)) {
            set.add(string2);
        }
    }
}

