/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.HandshakeCompletedListenerAdapter;

abstract class ProvSSLSocketBase
extends SSLSocket
implements BCSSLSocket {
    protected final Closeable socketCloser = new Closeable(){

        public void close() throws IOException {
            ProvSSLSocketBase.this.closeSocket();
        }
    };
    protected final Set<HandshakeCompletedListenerAdapter> listeners = Collections.synchronizedSet(new HashSet());

    protected ProvSSLSocketBase() {
    }

    protected ProvSSLSocketBase(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
    }

    protected ProvSSLSocketBase(InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
    }

    protected ProvSSLSocketBase(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        super(string, n, inetAddress, n2);
    }

    protected ProvSSLSocketBase(String string, int n) throws IOException, UnknownHostException {
        super(string, n);
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        this.listeners.add(new HandshakeCompletedListenerAdapter(handshakeCompletedListener));
    }

    protected void closeSocket() throws IOException {
        super.close();
    }

    public SocketChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    public boolean getOOBInline() throws SocketException {
        return false;
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        if (!this.listeners.remove(new HandshakeCompletedListenerAdapter(handshakeCompletedListener))) {
            throw new IllegalArgumentException("'listener' is not registered");
        }
    }

    public void sendUrgentData(int n) throws IOException {
        throw new UnsupportedOperationException("Urgent data not supported in TLS");
    }

    public void setOOBInline(boolean bl) throws SocketException {
        if (bl) {
            throw new UnsupportedOperationException("Urgent data not supported in TLS");
        }
    }

    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("shutdownInput() not supported in TLS");
    }

    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException("shutdownOutput() not supported in TLS");
    }
}

