/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.bouncycastle.tls.DeferredHash;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.RecordPreview;
import org.bouncycastle.tls.SimpleOutputStream;
import org.bouncycastle.tls.TlsCompression;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsNullCompression;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsNullNullCipher;

class RecordStream {
    private static int DEFAULT_PLAINTEXT_LIMIT = 16384;
    private final Record inputRecord = new Record();
    private TlsProtocol handler;
    private InputStream input;
    private OutputStream output;
    private TlsCompression pendingCompression = null;
    private TlsCompression readCompression = null;
    private TlsCompression writeCompression = null;
    private TlsCipher pendingCipher = null;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;
    private SequenceNumber readSeqNo = new SequenceNumber();
    private SequenceNumber writeSeqNo = new SequenceNumber();
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private TlsHandshakeHash handshakeHash = null;
    private SimpleOutputStream handshakeHashUpdater = new SimpleOutputStream(){

        public void write(byte[] byArray, int n, int n2) throws IOException {
            RecordStream.this.handshakeHash.update(byArray, n, n2);
        }
    };
    private ProtocolVersion readVersion = null;
    private ProtocolVersion writeVersion = null;
    private boolean restrictReadVersion = true;
    private int plaintextLimit;
    private int compressedLimit;
    private int ciphertextLimit;

    RecordStream(TlsProtocol tlsProtocol, InputStream inputStream, OutputStream outputStream) {
        this.handler = tlsProtocol;
        this.input = inputStream;
        this.output = outputStream;
        this.writeCompression = this.readCompression = new TlsNullCompression();
    }

    void init(TlsContext tlsContext) {
        this.writeCipher = this.readCipher = new TlsNullNullCipher();
        this.handshakeHash = new DeferredHash(tlsContext);
        this.setPlaintextLimit(DEFAULT_PLAINTEXT_LIMIT);
    }

    int getPlaintextLimit() {
        return this.plaintextLimit;
    }

    void setPlaintextLimit(int n) {
        this.plaintextLimit = n;
        this.compressedLimit = this.plaintextLimit + 1024;
        this.ciphertextLimit = this.compressedLimit + 1024;
    }

    ProtocolVersion getReadVersion() {
        return this.readVersion;
    }

    void setReadVersion(ProtocolVersion protocolVersion) {
        this.readVersion = protocolVersion;
    }

    void setWriteVersion(ProtocolVersion protocolVersion) {
        this.writeVersion = protocolVersion;
    }

    void setRestrictReadVersion(boolean bl) {
        this.restrictReadVersion = bl;
    }

    void setPendingConnectionState(TlsCompression tlsCompression, TlsCipher tlsCipher) {
        this.pendingCompression = tlsCompression;
        this.pendingCipher = tlsCipher;
    }

    void sentWriteCipherSpec() throws IOException {
        if (this.pendingCompression == null || this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.writeCompression = this.pendingCompression;
        this.writeCipher = this.pendingCipher;
        this.writeSeqNo = new SequenceNumber();
    }

    void receivedReadCipherSpec() throws IOException {
        if (this.pendingCompression == null || this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.readCompression = this.pendingCompression;
        this.readCipher = this.pendingCipher;
        this.readSeqNo = new SequenceNumber();
    }

    void finaliseHandshake() throws IOException {
        if (this.readCompression != this.pendingCompression || this.writeCompression != this.pendingCompression || this.readCipher != this.pendingCipher || this.writeCipher != this.pendingCipher) {
            throw new TlsFatalAlert(40);
        }
        this.pendingCompression = null;
        this.pendingCipher = null;
    }

    RecordPreview previewRecordHeader(byte[] byArray, boolean bl) throws IOException {
        int n;
        short s = TlsUtils.readUint8(byArray, 0);
        if (!bl && s == 23) {
            throw new TlsFatalAlert(10);
        }
        RecordStream.checkType(s, (short)10);
        if (!this.restrictReadVersion) {
            n = TlsUtils.readVersionRaw(byArray, 1);
            if ((n & 0xFFFFFF00) != 768) {
                throw new TlsFatalAlert(47);
            }
        } else {
            ProtocolVersion protocolVersion = TlsUtils.readVersion(byArray, 1);
            if (this.readVersion != null && !protocolVersion.equals(this.readVersion)) {
                throw new TlsFatalAlert(47);
            }
        }
        n = TlsUtils.readUint16(byArray, 3);
        RecordStream.checkLength(n, this.ciphertextLimit, (short)22);
        int n2 = 5 + n;
        int n3 = 0;
        if (s == 23) {
            n3 = this.getPlaintextLimit();
            if (this.readCompression.getClass() == TlsNullCompression.class) {
                n3 = Math.min(n3, this.readCipher.getPlaintextLimit(n));
            }
        }
        return new RecordPreview(n2, n3);
    }

    RecordPreview previewOutputRecord(int n) {
        int n2;
        int n3 = n2 = Math.max(0, Math.min(this.getPlaintextLimit(), n));
        if (this.writeCompression.getClass() != TlsNullCompression.class) {
            n3 += 1024;
        }
        n3 = this.writeCipher.getCiphertextLimit(n3) + 5;
        return new RecordPreview(n3, n2);
    }

    boolean readFullRecord(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 5) {
            return false;
        }
        int n3 = TlsUtils.readUint16(byArray, n + 3);
        if (n2 != 5 + n3) {
            return false;
        }
        short s = TlsUtils.readUint8(byArray, n + 0);
        RecordStream.checkType(s, (short)10);
        if (!this.restrictReadVersion) {
            int n4 = TlsUtils.readVersionRaw(byArray, n + 1);
            if ((n4 & 0xFFFFFF00) != 768) {
                throw new TlsFatalAlert(47);
            }
        } else {
            ProtocolVersion protocolVersion = TlsUtils.readVersion(byArray, n + 1);
            if (this.readVersion == null) {
                this.readVersion = protocolVersion;
            } else if (!protocolVersion.equals(this.readVersion)) {
                throw new TlsFatalAlert(47);
            }
        }
        RecordStream.checkLength(n3, this.ciphertextLimit, (short)22);
        byte[] byArray2 = this.decodeAndVerify(s, byArray, n + 5, n3);
        this.handler.processRecord(s, byArray2, 0, byArray2.length);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readRecord() throws IOException {
        byte[] byArray;
        int n;
        if (!this.inputRecord.readHeader(this.input)) {
            return false;
        }
        short s = TlsUtils.readUint8(this.inputRecord.buf, 0);
        RecordStream.checkType(s, (short)10);
        if (!this.restrictReadVersion) {
            n = TlsUtils.readVersionRaw(this.inputRecord.buf, 1);
            if ((n & 0xFFFFFF00) != 768) {
                throw new TlsFatalAlert(47);
            }
        } else {
            ProtocolVersion protocolVersion = TlsUtils.readVersion(this.inputRecord.buf, 1);
            if (this.readVersion == null) {
                this.readVersion = protocolVersion;
            } else if (!protocolVersion.equals(this.readVersion)) {
                throw new TlsFatalAlert(47);
            }
        }
        n = TlsUtils.readUint16(this.inputRecord.buf, 3);
        RecordStream.checkLength(n, this.ciphertextLimit, (short)22);
        this.inputRecord.readFragment(this.input, n);
        try {
            byArray = this.decodeAndVerify(s, this.inputRecord.buf, 5, n);
        }
        finally {
            this.inputRecord.reset();
        }
        this.handler.processRecord(s, byArray, 0, byArray.length);
        return true;
    }

    byte[] decodeAndVerify(short s, byte[] byArray, int n, int n2) throws IOException {
        long l = this.readSeqNo.nextValue((short)10);
        byte[] byArray2 = this.readCipher.decodeCiphertext(l, s, byArray, n, n2);
        RecordStream.checkLength(byArray2.length, this.compressedLimit, (short)22);
        OutputStream outputStream = this.readCompression.decompress(this.buffer);
        if (outputStream != this.buffer) {
            outputStream.write(byArray2, 0, byArray2.length);
            outputStream.flush();
            byArray2 = this.getBufferContents();
        }
        RecordStream.checkLength(byArray2.length, this.plaintextLimit, (short)30);
        if (byArray2.length < 1 && s != 23) {
            throw new TlsFatalAlert(47);
        }
        return byArray2;
    }

    void writeRecord(short s, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        byte[] byArray3;
        if (this.writeVersion == null) {
            return;
        }
        RecordStream.checkType(s, (short)80);
        RecordStream.checkLength(n2, this.plaintextLimit, (short)80);
        if (n2 < 1 && s != 23) {
            throw new TlsFatalAlert(80);
        }
        OutputStream outputStream = this.writeCompression.compress(this.buffer);
        long l = this.writeSeqNo.nextValue((short)80);
        if (outputStream == this.buffer) {
            byArray3 = this.writeCipher.encodePlaintext(l, s, byArray, n, n2);
        } else {
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            byArray2 = this.getBufferContents();
            RecordStream.checkLength(byArray2.length, n2 + 1024, (short)80);
            byArray3 = this.writeCipher.encodePlaintext(l, s, byArray2, 0, byArray2.length);
        }
        RecordStream.checkLength(byArray3.length, this.ciphertextLimit, (short)80);
        byArray2 = new byte[5 + byArray3.length];
        TlsUtils.writeUint8(s, byArray2, 0);
        TlsUtils.writeVersion(this.writeVersion, byArray2, 1);
        TlsUtils.writeUint16(byArray3.length, byArray2, 3);
        System.arraycopy(byArray3, 0, byArray2, 5, byArray3.length);
        try {
            this.output.write(byArray2);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new TlsFatalAlert(80, (Throwable)interruptedIOException);
        }
        this.output.flush();
    }

    void notifyHelloComplete() {
        this.handshakeHash = this.handshakeHash.notifyPRFDetermined();
    }

    TlsHandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    OutputStream getHandshakeHashUpdater() {
        return this.handshakeHashUpdater;
    }

    TlsHandshakeHash prepareToFinish() {
        TlsHandshakeHash tlsHandshakeHash = this.handshakeHash;
        this.handshakeHash = this.handshakeHash.stopTracking();
        return tlsHandshakeHash;
    }

    void close() throws IOException {
        IOException iOException;
        block5: {
            this.inputRecord.reset();
            iOException = null;
            try {
                this.input.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            try {
                this.output.close();
            }
            catch (IOException iOException3) {
                if (iOException != null) break block5;
                iOException = iOException3;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    void flush() throws IOException {
        this.output.flush();
    }

    private byte[] getBufferContents() {
        byte[] byArray = this.buffer.toByteArray();
        this.buffer.reset();
        return byArray;
    }

    private static void checkType(short s, short s2) throws IOException {
        switch (s) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                throw new TlsFatalAlert(s2);
            }
        }
    }

    private static void checkLength(int n, int n2, short s) throws IOException {
        if (n > n2) {
            throw new TlsFatalAlert(s);
        }
    }

    private static class Record {
        private final byte[] header = new byte[5];
        volatile byte[] buf = this.header;
        volatile int pos = 0;

        private Record() {
        }

        void fillTo(InputStream inputStream, int n) throws IOException {
            while (this.pos < n) {
                try {
                    int n2 = inputStream.read(this.buf, this.pos, n - this.pos);
                    if (n2 < 0) break;
                    this.pos += n2;
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.pos += interruptedIOException.bytesTransferred;
                    interruptedIOException.bytesTransferred = 0;
                    throw interruptedIOException;
                }
            }
        }

        void readFragment(InputStream inputStream, int n) throws IOException {
            int n2 = 5 + n;
            this.resize(n2);
            this.fillTo(inputStream, n2);
            if (this.pos < n2) {
                throw new EOFException();
            }
        }

        boolean readHeader(InputStream inputStream) throws IOException {
            this.fillTo(inputStream, 5);
            if (this.pos == 0) {
                return false;
            }
            if (this.pos < 5) {
                throw new EOFException();
            }
            return true;
        }

        void reset() {
            this.buf = this.header;
            this.pos = 0;
        }

        private void resize(int n) {
            if (this.buf.length < n) {
                byte[] byArray = new byte[n];
                System.arraycopy(this.buf, 0, byArray, 0, this.pos);
                this.buf = byArray;
            }
        }
    }

    private static class SequenceNumber {
        private long value = 0L;
        private boolean exhausted = false;

        private SequenceNumber() {
        }

        synchronized long nextValue(short s) throws TlsFatalAlert {
            if (this.exhausted) {
                throw new TlsFatalAlert(s);
            }
            long l = this.value++;
            if (this.value == 0L) {
                this.exhausted = true;
            }
            return l;
        }
    }
}

