/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsBlockCipher
implements TlsCipher {
    protected final TlsCrypto crypto;
    protected final TlsCryptoParameters cryptoParams;
    protected final byte[] randomData;
    protected final boolean encryptThenMAC;
    protected final boolean useExplicitIV;
    protected final boolean useExtraPadding;
    protected final TlsBlockCipherImpl decryptCipher;
    protected final TlsBlockCipherImpl encryptCipher;
    protected final TlsSuiteMac readMac;
    protected final TlsSuiteMac writeMac;

    public TlsBlockCipher(TlsCrypto tlsCrypto, TlsCryptoParameters tlsCryptoParameters, TlsBlockCipherImpl tlsBlockCipherImpl, TlsBlockCipherImpl tlsBlockCipherImpl2, TlsHMAC tlsHMAC, TlsHMAC tlsHMAC2, int n) throws IOException {
        TlsBlockCipherImpl tlsBlockCipherImpl3;
        TlsBlockCipherImpl tlsBlockCipherImpl4;
        this.cryptoParams = tlsCryptoParameters;
        this.crypto = tlsCrypto;
        this.randomData = tlsCryptoParameters.getNonceGenerator().generateNonce(256);
        SecurityParameters securityParameters = tlsCryptoParameters.getSecurityParametersHandshake();
        this.encryptThenMAC = securityParameters.isEncryptThenMAC();
        this.useExplicitIV = TlsImplUtils.isTLSv11(tlsCryptoParameters);
        this.useExtraPadding = securityParameters.isExtendedPadding() && !tlsCryptoParameters.getServerVersion().isDTLS() && (this.encryptThenMAC || !securityParameters.isTruncatedHMac());
        this.encryptCipher = tlsBlockCipherImpl;
        this.decryptCipher = tlsBlockCipherImpl2;
        if (tlsCryptoParameters.isServer()) {
            tlsBlockCipherImpl4 = tlsBlockCipherImpl2;
            tlsBlockCipherImpl3 = tlsBlockCipherImpl;
        } else {
            tlsBlockCipherImpl4 = tlsBlockCipherImpl;
            tlsBlockCipherImpl3 = tlsBlockCipherImpl2;
        }
        int n2 = 2 * n + tlsHMAC.getMacLength() + tlsHMAC2.getMacLength();
        if (!this.useExplicitIV) {
            n2 += tlsBlockCipherImpl4.getBlockSize() + tlsBlockCipherImpl3.getBlockSize();
        }
        byte[] byArray = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n2);
        int n3 = 0;
        tlsHMAC.setKey(byArray, n3, tlsHMAC.getMacLength());
        tlsHMAC2.setKey(byArray, n3 += tlsHMAC.getMacLength(), tlsHMAC2.getMacLength());
        tlsBlockCipherImpl4.setKey(byArray, n3 += tlsHMAC2.getMacLength(), n);
        tlsBlockCipherImpl3.setKey(byArray, n3 += n, n);
        n3 += n;
        if (!this.useExplicitIV) {
            tlsBlockCipherImpl4.init(byArray, n3, tlsBlockCipherImpl4.getBlockSize());
            tlsBlockCipherImpl3.init(byArray, n3 += tlsBlockCipherImpl4.getBlockSize(), tlsBlockCipherImpl3.getBlockSize());
            n3 += tlsBlockCipherImpl3.getBlockSize();
        }
        if (n3 != n2) {
            throw new TlsFatalAlert(80);
        }
        if (tlsCryptoParameters.isServer()) {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
        } else {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
        }
    }

    @Override
    public int getCiphertextLimit(int n) {
        int n2 = this.encryptCipher.getBlockSize();
        int n3 = this.writeMac.getSize();
        int n4 = n;
        if (this.useExplicitIV) {
            n4 += n2;
        }
        n4 += this.useExtraPadding ? 256 : n2;
        if (this.encryptThenMAC) {
            n4 -= n4 % n2;
            n4 += n3;
        } else {
            n4 += n3;
            n4 -= n4 % n2;
        }
        return n4;
    }

    @Override
    public int getPlaintextLimit(int n) {
        int n2 = this.encryptCipher.getBlockSize();
        int n3 = this.writeMac.getSize();
        int n4 = n;
        if (this.encryptThenMAC) {
            n4 -= n3;
            n4 -= n4 % n2;
        } else {
            n4 -= n4 % n2;
            n4 -= n3;
        }
        --n4;
        if (this.useExplicitIV) {
            n4 -= n2;
        }
        return n4;
    }

    @Override
    public byte[] encodePlaintext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = this.encryptCipher.getBlockSize();
        int n5 = this.writeMac.getSize();
        int n6 = n2;
        if (!this.encryptThenMAC) {
            n6 += n5;
        }
        int n7 = n4 - n6 % n4;
        if (this.useExtraPadding) {
            n3 = (256 - n7) / n4;
            int n8 = this.chooseExtraPadBlocks(this.crypto.getSecureRandom(), n3);
            n7 += n8 * n4;
        }
        n3 = n2 + n5 + n7;
        if (this.useExplicitIV) {
            n3 += n4;
        }
        byte[] byArray2 = new byte[n3];
        int n9 = 0;
        if (this.useExplicitIV) {
            byte[] byArray3 = this.cryptoParams.getNonceGenerator().generateNonce(n4);
            this.encryptCipher.init(byArray3, 0, n4);
            System.arraycopy(byArray3, 0, byArray2, n9, n4);
            n9 += n4;
        }
        int n10 = n9;
        System.arraycopy(byArray, n, byArray2, n9, n2);
        n9 += n2;
        if (!this.encryptThenMAC) {
            byte[] byArray4 = this.writeMac.calculateMac(l, s, byArray, n, n2);
            System.arraycopy(byArray4, 0, byArray2, n9, byArray4.length);
            n9 += byArray4.length;
        }
        byte by = (byte)(n7 - 1);
        for (int i = 0; i < n7; ++i) {
            byArray2[n9++] = by;
        }
        this.encryptCipher.doFinal(byArray2, n10, n9 - n10, byArray2, n10);
        if (this.encryptThenMAC) {
            byte[] byArray5 = this.writeMac.calculateMac(l, s, byArray2, 0, n9);
            System.arraycopy(byArray5, 0, byArray2, n9, byArray5.length);
            n9 += byArray5.length;
        }
        return byArray2;
    }

    @Override
    public byte[] decodeCiphertext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5 = this.decryptCipher.getBlockSize();
        int n6 = this.readMac.getSize();
        int n7 = n5;
        n7 = this.encryptThenMAC ? (n7 += n6) : Math.max(n7, n6 + 1);
        if (this.useExplicitIV) {
            n7 += n5;
        }
        if (n2 < n7) {
            throw new TlsFatalAlert(50);
        }
        int n8 = n2;
        if (this.encryptThenMAC) {
            n8 -= n6;
        }
        if (n8 % n5 != 0) {
            throw new TlsFatalAlert(21);
        }
        if (this.encryptThenMAC) {
            n4 = n + n2;
            byte[] byArray2 = TlsUtils.copyOfRangeExact(byArray, n4 - n6, n4);
            byte[] byArray3 = this.readMac.calculateMac(l, s, byArray, n, n2 - n6);
            int n9 = n3 = !Arrays.constantTimeAreEqual((byte[])byArray3, (byte[])byArray2) ? 1 : 0;
            if (n3 != 0) {
                throw new TlsFatalAlert(20);
            }
        }
        if (this.useExplicitIV) {
            this.decryptCipher.init(byArray, n, n5);
            n += n5;
            n8 -= n5;
        }
        this.decryptCipher.doFinal(byArray, n, n8, byArray, n);
        n4 = this.checkPaddingConstantTime(byArray, n, n8, n5, this.encryptThenMAC ? 0 : n6);
        boolean bl = n4 == 0;
        int n10 = n8 - n4;
        if (!this.encryptThenMAC) {
            n3 = n10 -= n6;
            int n11 = n + n3;
            byte[] byArray4 = TlsUtils.copyOfRangeExact(byArray, n11, n11 + n6);
            byte[] byArray5 = this.readMac.calculateMacConstantTime(l, s, byArray, n, n3, n8 - n6, this.randomData);
            bl |= !Arrays.constantTimeAreEqual((byte[])byArray5, (byte[])byArray4);
        }
        if (bl) {
            throw new TlsFatalAlert(20);
        }
        return TlsUtils.copyOfRangeExact(byArray, n, n + n10);
    }

    protected int checkPaddingConstantTime(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n + n2;
        byte by = byArray[n5 - 1];
        int n6 = by & 0xFF;
        int n7 = n6 + 1;
        int n8 = 0;
        int n9 = 0;
        if (n4 + n7 > n2) {
            n7 = 0;
        } else {
            int n10 = n5 - n7;
            do {
                n9 = (byte)(n9 | byArray[n10++] ^ by);
            } while (n10 < n5);
            n8 = n7;
            if (n9 != 0) {
                n7 = 0;
            }
        }
        byte[] byArray2 = this.randomData;
        while (n8 < 256) {
            n9 = (byte)(n9 | byArray2[n8++] ^ by);
        }
        byArray2[0] = (byte)(byArray2[0] ^ n9);
        return n7;
    }

    protected int chooseExtraPadBlocks(SecureRandom secureRandom, int n) {
        int n2 = secureRandom.nextInt();
        int n3 = this.lowestBitSet(n2);
        return Math.min(n3, n);
    }

    protected int lowestBitSet(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 0;
        while ((n & 1) == 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }
}

