/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;

public class PacketCipherException
extends Exception {
    private final Reason reason;

    public static PacketCipherException from(Throwable throwable) {
        if (throwable instanceof PacketCipherException) {
            return (PacketCipherException)throwable;
        }
        if (throwable instanceof InvalidCipherTextException) {
            return new PacketCipherException(Reason.INVALID_CIPHERTEXT, throwable.getMessage(), throwable);
        }
        if (throwable instanceof OutputLengthException) {
            return new PacketCipherException(Reason.OUTPUT_LENGTH, throwable.getMessage(), throwable);
        }
        if (throwable instanceof DataLengthException) {
            return new PacketCipherException(Reason.DATA_LENGTH, throwable.getMessage(), throwable);
        }
        return new PacketCipherException(Reason.OTHER, throwable.getMessage(), throwable);
    }

    private PacketCipherException(Reason reason, String message, Throwable cause) {
        super(message, cause);
        this.reason = reason;
    }

    public void throwCauseAsRuntimeException() {
        Throwable inner = this.getCause();
        if (inner instanceof RuntimeException) {
            throw (RuntimeException)inner;
        }
        throw new RuntimeException(inner.getMessage(), inner);
    }

    @Override
    public String toString() {
        return this.reason.toString() + " " + super.toString();
    }

    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        INVALID_CIPHERTEXT,
        OUTPUT_LENGTH,
        DATA_LENGTH,
        OTHER;

    }
}

