/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

class SHA512NativeDigest
implements SavableDigest {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;

    SHA512NativeDigest(CryptoServicePurpose purpose) {
        this.purpose = purpose;
        this.nativeRef = new DigestRefWrapper(SHA512NativeDigest.makeNative());
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    SHA512NativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    SHA512NativeDigest(SHA512NativeDigest src) {
        this(CryptoServicePurpose.ANY);
        byte[] state = src.getEncodedState();
        SHA512NativeDigest.restoreFullState(this.nativeRef.getReference(), state, 0);
    }

    SHA512NativeDigest restoreState(byte[] state, int offset) {
        SHA512NativeDigest.restoreFullState(this.nativeRef.getReference(), state, offset);
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-512";
    }

    @Override
    public int getDigestSize() {
        return SHA512NativeDigest.getDigestSize(this.nativeRef.getReference());
    }

    @Override
    public void update(byte in) {
        SHA512NativeDigest.update(this.nativeRef.getReference(), in);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        SHA512NativeDigest.update(this.nativeRef.getReference(), input, inOff, len);
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        return SHA512NativeDigest.doFinal(this.nativeRef.getReference(), output, outOff);
    }

    @Override
    public void reset() {
        SHA512NativeDigest.reset(this.nativeRef.getReference());
    }

    @Override
    public int getByteLength() {
        return SHA512NativeDigest.getByteLength(this.nativeRef.getReference());
    }

    @Override
    public Memoable copy() {
        return new SHA512NativeDigest(this);
    }

    @Override
    public void reset(Memoable other) {
        SHA512NativeDigest dig = (SHA512NativeDigest)other;
        SHA512NativeDigest.restoreFullState(this.nativeRef.getReference(), dig.getEncodedState(), 0);
    }

    @Override
    public byte[] getEncodedState() {
        int l = SHA512NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
        byte[] state = new byte[l];
        SHA512NativeDigest.encodeFullState(this.nativeRef.getReference(), state, 0);
        return state;
    }

    void restoreFullState(byte[] encoded, int offset) {
        SHA512NativeDigest.restoreFullState(this.nativeRef.getReference(), encoded, offset);
    }

    public String toString() {
        return "SHA512[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 512, this.purpose);
    }

    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long reference) {
            super(reference, "SHA512");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long ref) {
            super(ref);
        }

        @Override
        protected void dispose(long reference) {
            SHA512NativeDigest.destroy(reference);
        }
    }
}

