/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.SavableDigestXof;
import org.bouncycastle.crypto.digests.KeccakDigest;
import org.bouncycastle.crypto.digests.SHAKENativeDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class SHAKEDigest
extends KeccakDigest
implements SavableDigestXof {
    private static int checkBitLength(int bitStrength) {
        switch (bitStrength) {
            case 128: 
            case 256: {
                return bitStrength;
            }
        }
        throw new IllegalArgumentException("'bitStrength' " + bitStrength + " not supported for SHAKE");
    }

    public static SavableDigestXof newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest();
        }
        return new SHAKEDigest();
    }

    public SHAKEDigest() {
        this(128);
    }

    public static SavableDigestXof newInstance(CryptoServicePurpose purpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest(purpose);
        }
        return new SHAKEDigest(purpose);
    }

    public SHAKEDigest(CryptoServicePurpose purpose) {
        this(128, purpose);
    }

    public static SavableDigestXof newInstance(int bitStrength) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest(bitStrength);
        }
        return new SHAKEDigest(bitStrength);
    }

    public SHAKEDigest(int bitStrength) {
        super(SHAKEDigest.checkBitLength(bitStrength), CryptoServicePurpose.ANY);
    }

    public static SavableDigestXof newInstance(int bitStrength, CryptoServicePurpose purpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest(bitStrength, purpose);
        }
        return new SHAKEDigest(bitStrength, purpose);
    }

    public static SavableDigestXof newInstance(byte[] encoded, CryptoServicePurpose purpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest(encoded, purpose);
        }
        return new SHAKEDigest(encoded, purpose);
    }

    public SHAKEDigest(int bitStrength, CryptoServicePurpose purpose) {
        super(SHAKEDigest.checkBitLength(bitStrength), purpose);
    }

    public static SavableDigestXof newInstance(Digest digest) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE") && digest instanceof SHAKENativeDigest) {
            return new SHAKENativeDigest((SHAKENativeDigest)digest);
        }
        if (digest instanceof SHAKEDigest) {
            return new SHAKEDigest((SHAKEDigest)digest);
        }
        throw new IllegalArgumentException("digest must be either SHAKENativeDigest or SHAKEDigest");
    }

    public SHAKEDigest(SHAKEDigest source) {
        super(source);
    }

    public SHAKEDigest(byte[] encoded) {
        if (encoded.length != 13 + this.state.length * 8) {
            throw new IllegalArgumentException("encoded state has incorrect length");
        }
        this.bitsInQueue = Pack.bigEndianToInt(encoded, 0);
        this.rate = Pack.bigEndianToInt(encoded, 4);
        this.squeezing = Integer.MAX_VALUE == Pack.bigEndianToInt(encoded, 8);
        this.fixedOutputLength = Pack.bigEndianToInt(encoded, 12);
        int p = 16;
        for (int t = 0; t < this.state.length; ++t) {
            this.state[t] = Pack.bigEndianToInt(encoded, p += 8);
        }
        this.purpose = CryptoServicePurpose.values()[encoded[p]];
    }

    public SHAKEDigest(byte[] encoded, CryptoServicePurpose purpose) {
        this(encoded);
        this.purpose = purpose;
    }

    @Override
    public String getAlgorithmName() {
        return "SHAKE" + this.fixedOutputLength;
    }

    @Override
    public int getDigestSize() {
        return this.fixedOutputLength / 4;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.doFinal(out, outOff, this.getDigestSize());
    }

    @Override
    public int doFinal(byte[] out, int outOff, int outLen) {
        int length = this.doOutput(out, outOff, outLen);
        this.reset();
        return length;
    }

    @Override
    public int doOutput(byte[] out, int outOff, int outLen) {
        if (!this.squeezing) {
            this.absorbBits(15, 4);
        }
        this.squeeze(out, outOff, (long)outLen * 8L);
        return outLen;
    }

    @Override
    protected int doFinal(byte[] out, int outOff, byte partialByte, int partialBits) {
        return this.doFinal(out, outOff, this.getDigestSize(), partialByte, partialBits);
    }

    protected int doFinal(byte[] out, int outOff, int outLen, byte partialByte, int partialBits) {
        if (partialBits < 0 || partialBits > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int finalInput = partialByte & (1 << partialBits) - 1 | 15 << partialBits;
        int finalBits = partialBits + 4;
        if (finalBits >= 8) {
            this.absorb((byte)finalInput);
            finalBits -= 8;
            finalInput >>>= 8;
        }
        if (finalBits > 0) {
            this.absorbBits(finalInput, finalBits);
        }
        this.squeeze(out, outOff, (long)outLen * 8L);
        this.reset();
        return outLen;
    }

    @Override
    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, this.purpose);
    }

    public String toString() {
        return "SHAKE[Java]()";
    }

    @Override
    public byte[] getEncodedState() {
        byte[] out = new byte[13 + this.state.length * 8];
        Pack.intToBigEndian(this.bitsInQueue, out, 0);
        Pack.intToBigEndian(this.rate, out, 4);
        Pack.intToBigEndian(this.squeezing ? Integer.MIN_VALUE : 0, out, 8);
        Pack.intToBigEndian(this.fixedOutputLength, out, 12);
        int p = 16;
        for (long s : this.state) {
            Pack.longToBigEndian(s, out, p += 8);
        }
        this.state[this.state.length - 1] = (byte)this.purpose.ordinal();
        return out;
    }

    @Override
    public Memoable copy() {
        return new SHAKEDigest(this);
    }

    @Override
    public void reset(Memoable other) {
        if (!(other instanceof SHAKEDigest)) {
            throw new IllegalArgumentException("no SHAKEDigest instance");
        }
        this.bitsInQueue = ((SHAKEDigest)other).bitsInQueue;
        this.rate = ((SHAKEDigest)other).rate;
        this.squeezing = ((SHAKEDigest)other).squeezing;
        this.fixedOutputLength = ((SHAKEDigest)other).fixedOutputLength;
        System.arraycopy(((SHAKEDigest)other).state, 0, this.state, 0, this.state.length);
        this.purpose = ((SHAKEDigest)other).purpose;
    }
}

