/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.modes.AESCBCModePacketCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESNativeCBCPacketCipher
implements PacketCipher,
AESCBCModePacketCipher {
    @Override
    public int getOutputSize(boolean encryption, CipherParameters parameters, int len) {
        try {
            this.checkParameters(parameters);
        }
        catch (PacketCipherException e) {
            e.throwCauseAsRuntimeException();
        }
        return AESNativeCBCPacketCipher.getOutputSize(len);
    }

    @Override
    public int processPacket(boolean encryption, CipherParameters parameters, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        int result;
        byte[] key;
        byte[] iv;
        try {
            KeyParameter params;
            if (parameters instanceof ParametersWithIV) {
                ParametersWithIV ivParam = (ParametersWithIV)parameters;
                iv = (byte[])ivParam.getIV().clone();
                params = (KeyParameter)ivParam.getParameters();
                if (params == null) {
                    throw new IllegalArgumentException("CBC cipher unitialized");
                }
            } else {
                throw new IllegalArgumentException("invalid parameter type");
            }
            key = params.getKey();
        }
        catch (IllegalArgumentException e) {
            throw PacketCipherException.from(e);
        }
        int outLen = output != null ? output.length - outOff : 0;
        try {
            result = AESNativeCBCPacketCipher.processPacket(encryption, key, iv, input, inOff, len, output, outOff, outLen);
        }
        catch (Exception e) {
            throw PacketCipherException.from(e);
        }
        return result;
    }

    static native int getOutputSize(int var0);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    public String toString() {
        return "CBC-PS[Native](AES[Native])";
    }
}

