/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.expiry;

import org.cache2k.expiry.ExpiryTimeValues;

public class Expiry
implements ExpiryTimeValues {
    public static long toSharpTime(long millis) {
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        if (millis < 0L) {
            return millis;
        }
        return -millis;
    }

    public static long earliestTime(long loadTime, long candidate1, long candidate2) {
        if (candidate1 >= loadTime && (candidate1 < candidate2 || candidate2 < loadTime)) {
            return candidate1;
        }
        if (candidate2 >= loadTime) {
            return candidate2;
        }
        return Long.MAX_VALUE;
    }

    public static long mixTimeSpanAndPointInTime(long loadTime, long refreshAfter, long pointInTime) {
        long _refreshTime = loadTime + refreshAfter;
        if (_refreshTime < 0L) {
            _refreshTime = Long.MAX_VALUE;
        }
        if (pointInTime == Long.MAX_VALUE) {
            return _refreshTime;
        }
        if (pointInTime > _refreshTime) {
            return _refreshTime;
        }
        long _absPointInTime = Math.abs(pointInTime);
        if (_absPointInTime <= _refreshTime) {
            return pointInTime;
        }
        long _pointInTimeMinusDelta = _absPointInTime - refreshAfter;
        if (_pointInTimeMinusDelta < _refreshTime) {
            return _pointInTimeMinusDelta;
        }
        return _refreshTime;
    }
}

