/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.CacheOperationCompletionListener;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.EntryAction;
import org.cache2k.core.InternalCache;
import org.cache2k.jcache.provider.JCacheManagerAdapter;
import org.cache2k.jcache.provider.event.EventHandling;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.MutableCacheEntry;

public class JCacheAdapter<K, V>
implements javax.cache.Cache<K, V> {
    private final JCacheManagerAdapter manager;
    protected final InternalCache<K, V> cache;
    private final boolean storeByValue;
    private final boolean loaderConfigured;
    protected final boolean readThrough;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final EventHandling<K, V> eventHandling;
    protected final AtomicLong iterationHitCorrectionCounter = new AtomicLong();
    protected volatile boolean jmxStatisticsEnabled = false;
    protected volatile boolean jmxEnabled = false;

    public JCacheAdapter(JCacheManagerAdapter _manager, Cache<K, V> _cache, Class<K> _keyType, Class<V> _valueType, boolean _storeByValue, boolean _readThrough, boolean _loaderConfigured, EventHandling<K, V> _eventHandling) {
        this.manager = _manager;
        this.cache = (InternalCache)_cache;
        this.keyType = _keyType;
        this.valueType = _valueType;
        this.storeByValue = _storeByValue;
        this.readThrough = _readThrough;
        this.loaderConfigured = _loaderConfigured;
        this.eventHandling = _eventHandling;
    }

    public V get(K k) {
        this.checkClosed();
        if (this.readThrough) {
            return (V)this.cache.get(k);
        }
        return (V)this.cache.peek(k);
    }

    public Map<K, V> getAll(Set<? extends K> _keys) {
        this.checkClosed();
        if (this.readThrough) {
            return this.cache.getAll(_keys);
        }
        return this.cache.peekAll(_keys);
    }

    public boolean containsKey(K key) {
        this.checkClosed();
        return this.cache.containsKey(key);
    }

    public void loadAll(final Set<? extends K> keys, boolean replaceExistingValues, final CompletionListener completionListener) {
        this.checkClosed();
        if (!this.loaderConfigured) {
            if (completionListener != null) {
                completionListener.onCompletion();
            }
            return;
        }
        CacheOperationCompletionListener l = null;
        if (completionListener != null) {
            l = new CacheOperationCompletionListener(){

                public void onCompleted() {
                    try {
                        for (Object k : keys) {
                            JCacheAdapter.this.cache.peek(k);
                        }
                    }
                    catch (CacheLoaderException ex) {
                        completionListener.onException((Exception)((Object)ex));
                        return;
                    }
                    completionListener.onCompletion();
                }

                public void onException(Throwable _exception) {
                    if (_exception instanceof Exception) {
                        completionListener.onException((Exception)_exception);
                    } else {
                        completionListener.onException((Exception)((Object)new CacheLoaderException(_exception)));
                    }
                }
            };
        }
        if (replaceExistingValues) {
            this.cache.reloadAll(keys, l);
        } else {
            this.cache.loadAll(keys, l);
        }
    }

    public void put(K k, V v) {
        this.checkClosed();
        JCacheAdapter.checkNullValue(v);
        try {
            this.cache.put(k, v);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
    }

    public V getAndPut(K key, V _value) {
        this.checkClosed();
        JCacheAdapter.checkNullValue(_value);
        try {
            return (V)this.cache.peekAndPut(key, _value);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
    }

    private static void checkNullValue(Object _value) {
        if (_value == null) {
            throw new NullPointerException("null value not supported");
        }
    }

    void checkNullKey(K key) {
        if (key == null) {
            throw new NullPointerException("null key not supported");
        }
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.checkClosed();
        if (map == null) {
            throw new NullPointerException("null map parameter");
        }
        if (map.containsKey(null)) {
            throw new NullPointerException("null key not allowed");
        }
        for (Map.Entry<K, V> e : map.entrySet()) {
            JCacheAdapter.checkNullValue(e.getValue());
        }
        try {
            this.cache.putAll(map);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
    }

    public boolean putIfAbsent(K key, V _value) {
        this.checkClosed();
        JCacheAdapter.checkNullValue(_value);
        try {
            return this.cache.putIfAbsent(key, _value);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
    }

    public boolean remove(K key) {
        this.checkClosed();
        try {
            return this.cache.containsAndRemove(key);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
    }

    public boolean remove(K key, V _oldValue) {
        this.checkClosed();
        JCacheAdapter.checkNullValue(_oldValue);
        try {
            return this.cache.removeIfEquals(key, _oldValue);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
    }

    public V getAndRemove(K key) {
        this.checkClosed();
        try {
            return (V)this.cache.peekAndRemove(key);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
    }

    public boolean replace(K key, V _oldValue, V _newValue) {
        this.checkClosed();
        JCacheAdapter.checkNullValue(_oldValue);
        JCacheAdapter.checkNullValue(_newValue);
        try {
            return this.cache.replaceIfEquals(key, _oldValue, _newValue);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
    }

    public boolean replace(K key, V _value) {
        this.checkClosed();
        JCacheAdapter.checkNullValue(_value);
        try {
            return this.cache.replace(key, _value);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
    }

    public V getAndReplace(K key, V _value) {
        this.checkClosed();
        JCacheAdapter.checkNullValue(_value);
        try {
            return (V)this.cache.peekAndReplace(key, _value);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
    }

    public void removeAll(Set<? extends K> keys) {
        this.checkClosed();
        try {
            this.cache.removeAll(keys);
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
    }

    public void removeAll() {
        this.checkClosed();
        try {
            this.cache.removeAll();
        }
        catch (EntryAction.ListenerException ex) {
            throw new CacheEntryListenerException((Throwable)ex);
        }
        catch (org.cache2k.integration.CacheWriterException ex) {
            throw new CacheWriterException((Throwable)ex);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> _class) {
        if (CompleteConfiguration.class.isAssignableFrom(_class)) {
            MutableConfiguration cfg = new MutableConfiguration();
            cfg.setTypes(this.keyType, this.valueType);
            cfg.setStatisticsEnabled(this.jmxStatisticsEnabled);
            cfg.setManagementEnabled(this.jmxEnabled);
            cfg.setStoreByValue(this.storeByValue);
            Collection<CacheEntryListenerConfiguration<K, V>> _listenerConfigurations = this.eventHandling.getAllListenerConfigurations();
            for (CacheEntryListenerConfiguration<K, V> _listenerConfig : _listenerConfigurations) {
                cfg.addCacheEntryListenerConfiguration(_listenerConfig);
            }
            return (C)cfg;
        }
        return (C)new Configuration<K, V>(){

            public Class<K> getKeyType() {
                return JCacheAdapter.this.keyType;
            }

            public Class<V> getValueType() {
                return JCacheAdapter.this.valueType;
            }

            public boolean isStoreByValue() {
                return JCacheAdapter.this.storeByValue;
            }
        };
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.checkClosed();
        this.checkNullKey(key);
        Map<K, EntryProcessorResult<T>> m = this.invokeAll(Collections.singleton(key), entryProcessor, arguments);
        return (T)(!m.isEmpty() ? m.values().iterator().next().get() : null);
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, final Object ... arguments) {
        this.checkClosed();
        if (entryProcessor == null) {
            throw new NullPointerException("processor is null");
        }
        org.cache2k.processor.EntryProcessor p = new org.cache2k.processor.EntryProcessor<K, V, T>(){

            public T process(MutableCacheEntry<K, V> e) {
                MutableEntryAdapter me = new MutableEntryAdapter(e);
                Object _result = entryProcessor.process((MutableEntry)me, arguments);
                return _result;
            }
        };
        Map _result = this.cache.invokeAll(keys, p);
        HashMap _mappedResult = new HashMap();
        for (Map.Entry e : _result.entrySet()) {
            final EntryProcessingResult pr = (EntryProcessingResult)e.getValue();
            EntryProcessorResult epr = new EntryProcessorResult<T>(){

                public T get() throws EntryProcessorException {
                    Throwable t = pr.getException();
                    if (t != null) {
                        throw new EntryProcessorException(t);
                    }
                    return pr.getResult();
                }
            };
            _mappedResult.put(e.getKey(), epr);
        }
        return _mappedResult;
    }

    public String getName() {
        return this.cache.getName();
    }

    public CacheManager getCacheManager() {
        return this.manager;
    }

    public void close() {
        this.cache.close();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (Cache.class.equals(clazz)) {
            return (T)this.cache;
        }
        throw new IllegalArgumentException("requested class unknown");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cfg) {
        this.eventHandling.registerListener(cfg);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cfg) {
        if (cfg == null) {
            throw new NullPointerException();
        }
        this.eventHandling.deregisterListener(cfg);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkClosed();
        final Iterator _keyIterator = this.cache.keys().iterator();
        return new Iterator<Cache.Entry<K, V>>(){
            CacheEntry<K, V> entry;

            @Override
            public boolean hasNext() {
                while (_keyIterator.hasNext()) {
                    this.entry = JCacheAdapter.this.cache.getEntry(_keyIterator.next());
                    if (this.entry.getException() != null) continue;
                    return true;
                }
                this.entry = null;
                return false;
            }

            @Override
            public Cache.Entry<K, V> next() {
                if (this.entry == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new Cache.Entry<K, V>(){

                    public K getKey() {
                        return entry.getKey();
                    }

                    public V getValue() {
                        return entry.getValue();
                    }

                    public <T> T unwrap(Class<T> _class) {
                        if (CacheEntry.class.equals(_class)) {
                            return (T)entry;
                        }
                        return null;
                    }
                };
            }

            @Override
            public void remove() {
                if (this.entry == null) {
                    throw new IllegalStateException("hasNext() / next() not called or end of iteration reached");
                }
                JCacheAdapter.this.cache.remove(this.entry.getKey());
            }
        };
    }

    void checkClosed() {
        if (this.cache.isClosed()) {
            throw new CacheClosedException(this.cache);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "!" + this.cache;
    }

    private class MutableEntryAdapter
    implements MutableEntry<K, V> {
        private final MutableCacheEntry<K, V> entry;

        MutableEntryAdapter(MutableCacheEntry<K, V> e) {
            this.entry = e;
        }

        public boolean exists() {
            return this.entry.exists();
        }

        public void remove() {
            this.entry.remove();
        }

        public void setValue(V value) {
            JCacheAdapter.checkNullValue(value);
            this.entry.setValue(value);
        }

        public K getKey() {
            return this.entry.getKey();
        }

        public V getValue() {
            if (!JCacheAdapter.this.readThrough && !this.exists()) {
                return null;
            }
            return this.entry.getValue();
        }

        public <T> T unwrap(Class<T> clazz) {
            return null;
        }
    }
}

