/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.cache2k.core.Cache2kCoreProviderImpl;
import org.cache2k.jcache.provider.JCacheManagerAdapter;
import org.cache2k.spi.Cache2kCoreProvider;
import org.cache2k.spi.SingleProviderResolver;

public class JCacheProvider
implements CachingProvider {
    private final Cache2kCoreProvider forwardProvider = (Cache2kCoreProvider)SingleProviderResolver.resolveMandatory(Cache2kCoreProvider.class);
    private final Map<ClassLoader, Map<URI, JCacheManagerAdapter>> classLoader2uri2cache = new WeakHashMap<ClassLoader, Map<URI, JCacheManagerAdapter>>();

    private Object getLockObject() {
        return ((Cache2kCoreProviderImpl)this.forwardProvider).getLockObject();
    }

    public URI name2Uri(String _name) {
        try {
            return new URI(_name);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String uri2Name(URI uri) {
        String s = uri.toString();
        if (uri.getScheme() != null || s.contains(".xml") || s.contains(File.separator)) {
            throw new IllegalArgumentException("Only cache manager name, e.g. new URI(\"name\"), expected in the URI, not a file name or path, https://cache2k.org/docs/latest/user-guide.html#jcache-uri-exception");
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI uri, ClassLoader cl, Properties p) {
        if (uri == null) {
            uri = this.getDefaultURI();
        }
        if (cl == null) {
            cl = this.getDefaultClassLoader();
        }
        Object object = this.getLockObject();
        synchronized (object) {
            JCacheManagerAdapter cm;
            Map<URI, JCacheManagerAdapter> map = this.classLoader2uri2cache.get(cl);
            if (map == null) {
                map = new HashMap<URI, JCacheManagerAdapter>();
                this.classLoader2uri2cache.put(cl, map);
            }
            if ((cm = map.get(uri)) != null && !cm.isClosed()) {
                return cm;
            }
            cm = new JCacheManagerAdapter(this, this.forwardProvider.getManager(cl, this.uri2Name(uri)));
            if (p != null && !p.isEmpty()) {
                Properties _managerProperties = cm.getProperties();
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    if (_managerProperties.containsKey(e.getKey())) continue;
                    _managerProperties.put(e.getKey(), e.getValue());
                }
            }
            map.put(uri, cm);
            return cm;
        }
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public URI getDefaultURI() {
        String _defaultName = this.forwardProvider.getDefaultManagerName(this.getDefaultClassLoader());
        URI _defaultUri = this.name2Uri(_defaultName);
        return _defaultUri;
    }

    public Properties getDefaultProperties() {
        return null;
    }

    public CacheManager getCacheManager(URI uri, ClassLoader cl) {
        return this.getCacheManager(uri, cl, this.getDefaultProperties());
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    public void close() {
        this.forwardProvider.close();
    }

    public void close(ClassLoader cl) {
        this.forwardProvider.close(cl);
    }

    public void close(URI uri, ClassLoader cl) {
        this.forwardProvider.close(cl, this.uri2Name(uri));
    }

    public boolean isSupported(OptionalFeature v) {
        return true;
    }
}

