/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.io.Closeable;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.jcache.provider.JCacheAdapter;
import org.cache2k.processor.MutableCacheEntry;

public class TouchyJCacheAdapter<K, V>
implements javax.cache.Cache<K, V> {
    Cache<K, V> c2kCache;
    JCacheAdapter<K, V> cache;
    ExpiryPolicy expiryPolicy;
    private static final CacheEntry DUMMY_ENTRY = new CacheEntry(){

        public Object getKey() {
            return null;
        }

        public Object getValue() {
            return null;
        }

        public Throwable getException() {
            return null;
        }

        public long getLastModification() {
            return 0L;
        }
    };

    public TouchyJCacheAdapter(JCacheAdapter<K, V> _cache, ExpiryPolicy _expiryPolicy) {
        this.expiryPolicy = _expiryPolicy;
        this.cache = _cache;
        this.c2kCache = _cache.cache;
    }

    public V get(K key) {
        return this.returnValue(key, this.cache.get(key));
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        final Map<? extends K, V> map = this.cache.getAll(keys);
        return new Map<K, V>(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return map.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return map.containsValue(value);
            }

            @Override
            public V get(Object key) {
                return TouchyJCacheAdapter.this.returnValue(key, map.get(key));
            }

            @Override
            public V put(K key, V value) {
                throw new UnsupportedOperationException("read only");
            }

            @Override
            public V remove(Object key) {
                return map.remove(key);
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> m) {
                throw new UnsupportedOperationException("read only");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("read only");
            }

            @Override
            public Set<K> keySet() {
                return map.keySet();
            }

            @Override
            public Collection<V> values() {
                return new AbstractCollection<V>(){

                    @Override
                    public int size() {
                        return map.size();
                    }

                    @Override
                    public boolean isEmpty() {
                        return map.isEmpty();
                    }

                    @Override
                    public Iterator<V> iterator() {
                        final Iterator it = map.entrySet().iterator();
                        return new Iterator<V>(){

                            @Override
                            public boolean hasNext() {
                                return it.hasNext();
                            }

                            @Override
                            public V next() {
                                Map.Entry e = (Map.Entry)it.next();
                                return TouchyJCacheAdapter.this.returnValue(e.getKey(), e.getValue());
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                final Iterator it = map.entrySet().iterator();
                return new AbstractSet<Map.Entry<K, V>>(){

                    @Override
                    public Iterator<Map.Entry<K, V>> iterator() {
                        return new Iterator<Map.Entry<K, V>>(){

                            @Override
                            public boolean hasNext() {
                                return it.hasNext();
                            }

                            @Override
                            public Map.Entry<K, V> next() {
                                final Map.Entry e = (Map.Entry)it.next();
                                return new Map.Entry<K, V>(){

                                    @Override
                                    public K getKey() {
                                        return e.getKey();
                                    }

                                    @Override
                                    public V getValue() {
                                        return TouchyJCacheAdapter.this.returnValue(e.getKey(), e.getValue());
                                    }

                                    @Override
                                    public V setValue(V value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return map.size();
                    }
                };
            }
        };
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.cache.loadAll(keys, replaceExistingValues, completionListener);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public V getAndPut(K key, V value) {
        this.checkClosed();
        return this.cache.getAndPut(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.cache.putAll(map);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.cache.putIfAbsent(key, value);
    }

    public boolean remove(K key) {
        return this.cache.remove(key);
    }

    public boolean remove(K key, final V oldValue) {
        this.checkClosed();
        this.checkNullValue(oldValue);
        if (key == null) {
            throw new NullPointerException();
        }
        org.cache2k.processor.EntryProcessor ep = new org.cache2k.processor.EntryProcessor<K, V, Boolean>(){

            public Boolean process(MutableCacheEntry<K, V> e) {
                if (!e.exists()) {
                    return false;
                }
                Object _existingValue = e.getValue();
                if (_existingValue.equals(oldValue)) {
                    e.remove();
                    return true;
                }
                Duration d = TouchyJCacheAdapter.this.expiryPolicy.getExpiryForAccess();
                if (d != null) {
                    e.setExpiryTime(TouchyJCacheAdapter.calculateExpiry(d));
                }
                return false;
            }
        };
        return (Boolean)this.c2kCache.invoke(key, ep);
    }

    public V getAndRemove(K key) {
        return this.cache.getAndRemove(key);
    }

    public boolean replace(K key, final V oldValue, final V newValue) {
        this.checkClosed();
        this.checkNullValue(newValue);
        this.checkNullValue(oldValue);
        return (Boolean)this.c2kCache.invoke(key, new org.cache2k.processor.EntryProcessor<K, V, Boolean>(){

            public Boolean process(MutableCacheEntry<K, V> e) {
                if (e.exists()) {
                    if (oldValue.equals(e.getValue())) {
                        e.setValue(newValue);
                        return true;
                    }
                    Duration d = TouchyJCacheAdapter.this.expiryPolicy.getExpiryForAccess();
                    if (d != null) {
                        e.setExpiryTime(TouchyJCacheAdapter.calculateExpiry(d));
                    }
                }
                return false;
            }
        });
    }

    public boolean replace(K key, V value) {
        this.checkClosed();
        this.checkNullValue(value);
        return this.c2kCache.replace(key, value);
    }

    public V getAndReplace(K key, V value) {
        return this.cache.getAndReplace(key, value);
    }

    public void removeAll(Set<? extends K> keys) {
        this.cache.removeAll(keys);
    }

    public void removeAll() {
        this.cache.removeAll();
    }

    public void clear() {
        this.cache.clear();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        return this.cache.getConfiguration(clazz);
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        return this.cache.invoke(key, this.wrapEntryProcessor(entryProcessor), arguments);
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        return this.cache.invokeAll(keys, this.wrapEntryProcessor(entryProcessor), arguments);
    }

    public String getName() {
        return this.cache.getName();
    }

    public CacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public void close() {
        this.cache.close();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.c2kCache.requestInterface(clazz);
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cfg) {
        this.cache.registerCacheEntryListener(cfg);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cfg) {
        this.cache.deregisterCacheEntryListener(cfg);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        final Iterator<Cache.Entry<K, V>> it = this.cache.iterator();
        return new Iterator<Cache.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Cache.Entry<K, V> next() {
                Cache.Entry e = (Cache.Entry)it.next();
                return TouchyJCacheAdapter.this.returnEntry(e);
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    private <T> EntryProcessor<K, V, T> wrapEntryProcessor(final EntryProcessor<K, V, T> ep) {
        if (ep == null) {
            throw new NullPointerException("processor is null");
        }
        return new EntryProcessor<K, V, T>(){
            boolean freshOrJustLoaded = false;

            public T process(final MutableEntry<K, V> e0, Object ... _args) throws EntryProcessorException {
                MutableEntry me = new MutableEntry<K, V>(){

                    public boolean exists() {
                        return e0.exists();
                    }

                    public void remove() {
                        e0.remove();
                    }

                    public void setValue(V value) {
                        TouchyJCacheAdapter.this.checkNullValue(value);
                        freshOrJustLoaded = true;
                        e0.setValue(value);
                    }

                    public K getKey() {
                        return e0.getKey();
                    }

                    public V getValue() {
                        boolean _doNotCountCacheAccessIfEntryGetsLoaded = !this.exists();
                        boolean _doNotCountCacheAccessIfEntryIsFresh = freshOrJustLoaded;
                        if (_doNotCountCacheAccessIfEntryIsFresh || _doNotCountCacheAccessIfEntryGetsLoaded) {
                            if (!TouchyJCacheAdapter.this.cache.readThrough && !this.exists()) {
                                return null;
                            }
                            freshOrJustLoaded = true;
                            return e0.getValue();
                        }
                        return TouchyJCacheAdapter.this.returnValue(e0.getKey(), e0.getValue());
                    }

                    public <X> X unwrap(Class<X> clazz) {
                        return null;
                    }
                };
                return ep.process(me, _args);
            }
        };
    }

    private Cache.Entry<K, V> returnEntry(Cache.Entry<K, V> e) {
        this.touchEntry(e.getKey());
        return e;
    }

    private V returnValue(K key, V _value) {
        if (_value != null) {
            Duration d = this.expiryPolicy.getExpiryForAccess();
            if (d != null) {
                this.c2kCache.expireAt(key, TouchyJCacheAdapter.calculateExpiry(d));
            }
            return _value;
        }
        return null;
    }

    private static long calculateExpiry(Duration d) {
        if (Duration.ZERO.equals((Object)d)) {
            return 0L;
        }
        if (Duration.ETERNAL.equals((Object)d)) {
            return Long.MAX_VALUE;
        }
        return System.currentTimeMillis() + d.getTimeUnit().toMillis(d.getDurationAmount());
    }

    private void touchEntry(K key) {
        Duration d = this.expiryPolicy.getExpiryForAccess();
        if (d != null) {
            this.c2kCache.expireAt(key, TouchyJCacheAdapter.calculateExpiry(d));
        }
    }

    private void checkClosed() {
        this.cache.checkClosed();
    }

    private void checkNullValue(V _value) {
        if (_value == null) {
            throw new NullPointerException("value is null");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "!" + this.cache.toString();
    }

    public static class ExpiryPolicyAdapter<K, V>
    implements org.cache2k.expiry.ExpiryPolicy<K, V>,
    Closeable {
        private ExpiryPolicy policy;

        public ExpiryPolicyAdapter(ExpiryPolicy policy) {
            this.policy = policy;
        }

        public long calculateExpiryTime(K _key, V _value, long _loadTime, CacheEntry<K, V> _oldEntry) {
            if (_value == null) {
                return 0L;
            }
            Duration d = _oldEntry == null || _oldEntry.getException() != null ? this.policy.getExpiryForCreation() : this.policy.getExpiryForUpdate();
            if (d == null) {
                return -1L;
            }
            if (d.equals((Object)Duration.ETERNAL)) {
                return Long.MAX_VALUE;
            }
            if (d.equals((Object)Duration.ZERO)) {
                return 0L;
            }
            return _loadTime + d.getTimeUnit().toMillis(d.getDurationAmount());
        }

        @Override
        public void close() throws IOException {
            if (this.policy instanceof Closeable) {
                ((Closeable)this.policy).close();
            }
        }
    }
}

