/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.com.google.common.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.checkerframework.nullaway.checker.index.qual.LessThanBottom;
import org.checkerframework.nullaway.checker.index.qual.LessThanUnknown;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundBottom;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.nullaway.checker.index.qual.SameLenBottom;
import org.checkerframework.nullaway.checker.index.qual.SameLenUnknown;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexBottom;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundBottom;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.nullaway.checker.initialization.qual.Initialized;
import org.checkerframework.nullaway.checker.nullness.qual.KeyForBottom;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.nullaway.checker.signedness.qual.Signed;
import org.checkerframework.nullaway.checker.signedness.qual.SignednessBottom;
import org.checkerframework.nullaway.com.google.common.annotations.GwtCompatible;
import org.checkerframework.nullaway.com.google.common.cache.Cache;
import org.checkerframework.nullaway.com.google.common.cache.CacheStats;
import org.checkerframework.nullaway.com.google.common.cache.ElementTypesAreNonnullByDefault;
import org.checkerframework.nullaway.com.google.common.cache.LongAddable;
import org.checkerframework.nullaway.com.google.common.cache.LongAddables;
import org.checkerframework.nullaway.com.google.common.collect.ImmutableMap;
import org.checkerframework.nullaway.com.google.common.collect.Maps;
import org.checkerframework.nullaway.common.value.qual.BottomVal;
import org.checkerframework.nullaway.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class AbstractCache<@SubstringIndexBottom K, @SubstringIndexBottom V>
implements Cache<K, V> {
    protected AbstractCache() {
    }

    @Override
    public V get(K key, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Callable<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @KeyForBottom @NonNull @Initialized @SignednessBottom ? extends V> valueLoader) throws @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ImmutableMap<K, V> getAllPresent(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterable<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @KeyForBottom @NonNull @Initialized @SignednessBottom ? extends @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object> keys) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object object : keys) {
            if (result.containsKey(object)) continue;
            Object castKey = object;
            Object value = this.getIfPresent(object);
            if (value == null) continue;
            result.put(castKey, value);
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public void put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @KeyForBottom @NonNull @Initialized @SignednessBottom ? extends K, @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @KeyForBottom @NonNull @Initialized @SignednessBottom ? extends V> m4) {
        for (Map.Entry<K, V> entry : m4.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidateAll(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterable<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @KeyForBottom @NonNull @Initialized @SignednessBottom ? extends @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object> keys) {
        for (Object object : keys) {
            this.invalidate(object);
        }
    }

    @Override
    public void invalidateAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed CacheStats stats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    public static final class SimpleStatsCounter
    implements StatsCounter {
        private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed LongAddable hitCount = LongAddables.create();
        private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed LongAddable missCount = LongAddables.create();
        private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed LongAddable loadSuccessCount = LongAddables.create();
        private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed LongAddable loadExceptionCount = LongAddables.create();
        private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed LongAddable totalLoadTime = LongAddables.create();
        private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed LongAddable evictionCount = LongAddables.create();

        @Override
        public void recordHits(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int count) {
            this.hitCount.add(count);
        }

        @Override
        public void recordMisses(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int count) {
            this.missCount.add(count);
        }

        @Override
        public void recordLoadSuccess(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long loadTime) {
            this.loadSuccessCount.increment();
            this.totalLoadTime.add(loadTime);
        }

        @Override
        public void recordLoadException(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long loadTime) {
            this.loadExceptionCount.increment();
            this.totalLoadTime.add(loadTime);
        }

        @Override
        public void recordEviction() {
            this.evictionCount.increment();
        }

        @Override
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed CacheStats snapshot() {
            return new CacheStats(SimpleStatsCounter.negativeToMaxValue(this.hitCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.missCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.loadSuccessCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.loadExceptionCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.totalLoadTime.sum()), SimpleStatsCounter.negativeToMaxValue(this.evictionCount.sum()));
        }

        private static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long negativeToMaxValue(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long value) {
            return value >= 0L ? value : Long.MAX_VALUE;
        }

        public void incrementBy(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed StatsCounter other) {
            CacheStats otherStats = other.snapshot();
            this.hitCount.add(otherStats.hitCount());
            this.missCount.add(otherStats.missCount());
            this.loadSuccessCount.add(otherStats.loadSuccessCount());
            this.loadExceptionCount.add(otherStats.loadExceptionCount());
            this.totalLoadTime.add(otherStats.totalLoadTime());
            this.evictionCount.add(otherStats.evictionCount());
        }
    }

    public static interface StatsCounter {
        public void recordHits(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int var1);

        public void recordMisses(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int var1);

        public void recordLoadSuccess(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long var1);

        public void recordLoadException(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long var1);

        public void recordEviction();

        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed CacheStats snapshot();
    }
}

