/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.com.google.common.escape;

import java.util.Map;
import javax.annotation.CheckForNull;
import org.checkerframework.nullaway.checker.index.qual.GTENegativeOne;
import org.checkerframework.nullaway.checker.index.qual.IndexOrHigh;
import org.checkerframework.nullaway.checker.index.qual.LTEqLengthOf;
import org.checkerframework.nullaway.checker.index.qual.LengthOf;
import org.checkerframework.nullaway.checker.index.qual.LessThanUnknown;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.nullaway.checker.index.qual.NonNegative;
import org.checkerframework.nullaway.checker.index.qual.SameLenUnknown;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.nullaway.checker.initialization.qual.Initialized;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.nullaway.checker.signedness.qual.Signed;
import org.checkerframework.nullaway.checker.signedness.qual.Unsigned;
import org.checkerframework.nullaway.com.google.common.annotations.GwtCompatible;
import org.checkerframework.nullaway.com.google.common.base.Preconditions;
import org.checkerframework.nullaway.com.google.common.escape.ArrayBasedEscaperMap;
import org.checkerframework.nullaway.com.google.common.escape.ElementTypesAreNonnullByDefault;
import org.checkerframework.nullaway.com.google.common.escape.UnicodeEscaper;
import org.checkerframework.nullaway.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ArrayBasedUnicodeEscaper
extends UnicodeEscaper {
    private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Unsigned char @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] replacements;
    private final @LengthOf(value={"replacements"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @NonNegative @LTEqLengthOf(value={"this.replacements"}) @UnknownKeyFor @NonNull @Initialized @Signed int replacementsLength;
    private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int safeMin;
    private final @GTENegativeOne @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int safeMax;
    private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Unsigned char safeMinChar;
    private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Unsigned char safeMaxChar;

    protected ArrayBasedUnicodeEscaper(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Unsigned Character, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed String> replacementMap, @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int safeMin, @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int safeMax, @Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @Signed String unsafeReplacement) {
        this(ArrayBasedEscaperMap.create(replacementMap), safeMin, safeMax, unsafeReplacement);
    }

    protected ArrayBasedUnicodeEscaper(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ArrayBasedEscaperMap escaperMap, @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int safeMin, @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int safeMax, @Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @Signed String unsafeReplacement) {
        Preconditions.checkNotNull(escaperMap);
        this.replacements = escaperMap.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        if (safeMax < safeMin) {
            safeMax = -1;
            safeMin = Integer.MAX_VALUE;
        }
        this.safeMin = safeMin;
        this.safeMax = safeMax;
        if (safeMin >= 55296) {
            this.safeMinChar = (char)65535;
            this.safeMaxChar = '\u0000';
        } else {
            this.safeMinChar = (char)safeMin;
            this.safeMaxChar = (char)Math.min(safeMax, 55295);
        }
    }

    @Override
    public final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed String escape(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed String s2) {
        Preconditions.checkNotNull(s2);
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if ((c >= this.replacementsLength || this.replacements[c] == null) && c <= this.safeMaxChar && c >= this.safeMinChar) continue;
            return this.escapeSlow(s2, i);
        }
        return s2;
    }

    @Override
    @CheckForNull
    protected final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Unsigned char @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed [] escape(@NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int cp) {
        char[] chars;
        if (cp < this.replacementsLength && (chars = this.replacements[cp]) != null) {
            return chars;
        }
        if (cp >= this.safeMin && cp <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe(cp);
    }

    @Override
    protected final @IndexOrHigh(value={"#1"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @NonNegative @LTEqLengthOf(value={"#1"}) @UnknownKeyFor @NonNull @Initialized @Signed int nextEscapeIndex(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed CharSequence csq, @IndexOrHigh(value={"#1"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @NonNegative @LTEqLengthOf(value={"#1"}) @UnknownKeyFor @NonNull @Initialized @Signed int index, @IndexOrHigh(value={"#1"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @NonNegative @LTEqLengthOf(value={"#1"}) @UnknownKeyFor @NonNull @Initialized @Signed int end) {
        char c;
        while (index < end && ((c = csq.charAt(index)) >= this.replacementsLength || this.replacements[c] == null) && c <= this.safeMaxChar && c >= this.safeMinChar) {
            ++index;
        }
        return index;
    }

    @CheckForNull
    protected abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Unsigned char @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed [] escapeUnsafe(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int var1);
}

