/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.nullaway.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.analysis.AnalysisResult;
import org.checkerframework.nullaway.dataflow.cfg.UnderlyingAST;
import org.checkerframework.nullaway.dataflow.cfg.block.Block;
import org.checkerframework.nullaway.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.nullaway.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.nullaway.dataflow.cfg.block.SpecialBlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.node.ReturnNode;
import org.checkerframework.nullaway.dataflow.cfg.visualize.StringCFGVisualizer;
import org.checkerframework.nullaway.org.plumelib.util.UniqueId;
import org.checkerframework.nullaway.org.plumelib.util.UnmodifiableIdentityHashMap;

public class ControlFlowGraph
implements UniqueId {
    protected final SpecialBlock entryBlock;
    protected final SpecialBlock regularExitBlock;
    protected final SpecialBlock exceptionalExitBlock;
    public final UnderlyingAST underlyingAST;
    private static final AtomicLong nextUid = new AtomicLong(0L);
    private final transient long uid = nextUid.getAndIncrement();
    protected final IdentityHashMap<Tree, Set<Node>> treeLookup;
    protected final IdentityHashMap<Tree, Set<Node>> convertedTreeLookup;
    protected final IdentityHashMap<UnaryTree, BinaryTree> postfixNodeLookup;
    protected final List<ReturnNode> returnNodes;
    protected final List<ClassTree> declaredClasses;
    protected final List<LambdaExpressionTree> declaredLambdas;

    @Override
    public long getUid(@UnknownInitialization ControlFlowGraph this) {
        return this.uid;
    }

    public ControlFlowGraph(SpecialBlock entryBlock, SpecialBlockImpl regularExitBlock, SpecialBlockImpl exceptionalExitBlock, UnderlyingAST underlyingAST, IdentityHashMap<Tree, Set<Node>> treeLookup, IdentityHashMap<Tree, Set<Node>> convertedTreeLookup, IdentityHashMap<UnaryTree, BinaryTree> postfixNodeLookup, List<ReturnNode> returnNodes, List<ClassTree> declaredClasses, List<LambdaExpressionTree> declaredLambdas) {
        this.entryBlock = entryBlock;
        this.underlyingAST = underlyingAST;
        this.treeLookup = treeLookup;
        this.postfixNodeLookup = postfixNodeLookup;
        this.convertedTreeLookup = convertedTreeLookup;
        this.regularExitBlock = regularExitBlock;
        this.exceptionalExitBlock = exceptionalExitBlock;
        this.returnNodes = returnNodes;
        this.declaredClasses = declaredClasses;
        this.declaredLambdas = declaredLambdas;
    }

    public void checkInvariants() {
        for (Block b : this.getAllBlocks()) {
            for (Node n : b.getNodes()) {
                if (Objects.equals(n.getBlock(), b)) continue;
                throw new IllegalStateException("Node " + n + " in block " + b + " incorrectly believes it belongs to " + n.getBlock());
            }
            for (Block succ : b.getSuccessors()) {
                if (succ.getPredecessors().contains(b)) continue;
                throw new IllegalStateException("Block " + b + " has successor " + succ + " but does not appear in that successor's predecessors");
            }
            for (Block pred : b.getPredecessors()) {
                if (pred.getSuccessors().contains(b)) continue;
                throw new IllegalStateException("Block " + b + " has predecessor " + pred + " but does not appear in that predecessor's successors");
            }
        }
    }

    public @Nullable Set<Node> getNodesCorrespondingToTree(Tree t2) {
        if (this.convertedTreeLookup.containsKey(t2)) {
            return this.convertedTreeLookup.get(t2);
        }
        return this.treeLookup.get(t2);
    }

    public SpecialBlock getEntryBlock() {
        return this.entryBlock;
    }

    public List<ReturnNode> getReturnNodes() {
        return this.returnNodes;
    }

    public SpecialBlock getRegularExitBlock() {
        return this.regularExitBlock;
    }

    public SpecialBlock getExceptionalExitBlock() {
        return this.exceptionalExitBlock;
    }

    public UnderlyingAST getUnderlyingAST() {
        return this.underlyingAST;
    }

    public Set<Block> getAllBlocks(@UnknownInitialization(value=ControlFlowGraph.class) ControlFlowGraph this) {
        LinkedHashSet<Block> visited = new LinkedHashSet<Block>();
        ArrayDeque<Block> worklist = new ArrayDeque<Block>();
        Block cur = this.entryBlock;
        visited.add(this.entryBlock);
        while (cur != null) {
            for (Block b : cur.getSuccessors()) {
                if (!visited.add(b)) continue;
                worklist.add(b);
            }
            cur = (Block)worklist.poll();
        }
        return visited;
    }

    public List<Node> getAllNodes(@UnknownInitialization(value=ControlFlowGraph.class) ControlFlowGraph this) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Block b : this.getAllBlocks()) {
            result.addAll(b.getNodes());
        }
        return result;
    }

    public Set<Block> getAllBlocks(@UnknownInitialization(value=ControlFlowGraph.class) ControlFlowGraph this, Function<TypeMirror, Boolean> shouldIgnoreException) {
        LinkedHashSet<Block> visited = new LinkedHashSet<Block>();
        ArrayDeque<Block> worklist = new ArrayDeque<Block>();
        Block cur = this.entryBlock;
        visited.add(this.entryBlock);
        while (cur != null) {
            if (cur instanceof ExceptionBlock) {
                for (Map.Entry entry : ((ExceptionBlock)cur).getExceptionalSuccessors().entrySet()) {
                    if (shouldIgnoreException.apply((TypeMirror)entry.getKey()).booleanValue()) continue;
                    for (Block b : (Set)entry.getValue()) {
                        if (!visited.add(b)) continue;
                        worklist.add(b);
                    }
                }
                Block b = ((SingleSuccessorBlockImpl)cur).getSuccessor();
                if (b != null && visited.add(b)) {
                    worklist.add(b);
                }
            } else {
                for (Block block : cur.getSuccessors()) {
                    if (!visited.add(block)) continue;
                    worklist.add(block);
                }
            }
            cur = (Block)worklist.poll();
        }
        return visited;
    }

    public List<Node> getAllNodes(@UnknownInitialization(value=ControlFlowGraph.class) ControlFlowGraph this, Function<TypeMirror, Boolean> shouldIgnoreException) {
        ArrayList<Node> result = new ArrayList<Node>();
        this.getAllBlocks(shouldIgnoreException).forEach(b -> result.addAll(b.getNodes()));
        return result;
    }

    public List<Block> getDepthFirstOrderedBlocks() {
        ArrayList<Block> dfsOrderResult = new ArrayList<Block>();
        HashSet<Block> visited = new HashSet<Block>();
        ArrayDeque<Block> worklist = new ArrayDeque<Block>();
        worklist.add(this.entryBlock);
        while (!worklist.isEmpty()) {
            Block cur = (Block)worklist.getLast();
            if (visited.contains(cur)) {
                dfsOrderResult.add(cur);
                worklist.removeLast();
                continue;
            }
            visited.add(cur);
            for (Block b : cur.getSuccessors()) {
                if (visited.contains(b)) continue;
                worklist.add(b);
            }
        }
        Collections.reverse(dfsOrderResult);
        return dfsOrderResult;
    }

    public UnmodifiableIdentityHashMap<Tree, Set<Node>> getTreeLookup() {
        return UnmodifiableIdentityHashMap.wrap(this.treeLookup);
    }

    public UnmodifiableIdentityHashMap<UnaryTree, BinaryTree> getPostfixNodeLookup() {
        return UnmodifiableIdentityHashMap.wrap(this.postfixNodeLookup);
    }

    public @Nullable MethodTree getContainingMethod(Tree t2) {
        if (this.treeLookup.containsKey(t2) && this.underlyingAST.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod cfgMethod = (UnderlyingAST.CFGMethod)this.underlyingAST;
            return cfgMethod.getMethod();
        }
        return null;
    }

    public @Nullable ClassTree getContainingClass(Tree t2) {
        if (this.treeLookup.containsKey(t2) && this.underlyingAST.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod cfgMethod = (UnderlyingAST.CFGMethod)this.underlyingAST;
            return cfgMethod.getClassTree();
        }
        return null;
    }

    public List<ClassTree> getDeclaredClasses() {
        return this.declaredClasses;
    }

    public List<LambdaExpressionTree> getDeclaredLambdas() {
        return this.declaredLambdas;
    }

    public String toString() {
        StringCFGVisualizer viz = new StringCFGVisualizer();
        viz.init(Collections.singletonMap("verbose", true));
        Map<String, Object> res = viz.visualize(this, this.getEntryBlock(), null);
        viz.shutdown();
        if (res == null) {
            return "unvisualizable " + this.getClass().getCanonicalName();
        }
        String stringGraph = (String)res.get("stringGraph");
        return stringGraph == null ? "unvisualizable " + this.getClass().getCanonicalName() : stringGraph;
    }

    public String toStringDebug() {
        String className = this.getClass().getSimpleName();
        if (className.equals("ControlFlowGraph") && this.getClass() != ControlFlowGraph.class) {
            className = this.getClass().getCanonicalName();
        }
        StringJoiner result = new StringJoiner(String.format("%n  ", new Object[0]));
        result.add(className + " #" + this.getUid() + " {");
        result.add("entryBlock=" + this.entryBlock);
        result.add("regularExitBlock=" + this.regularExitBlock);
        result.add("exceptionalExitBlock=" + this.exceptionalExitBlock);
        String astString = this.underlyingAST.toString().replaceAll("\\s", " ");
        if (astString.length() > 65) {
            astString = "\"" + astString.substring(0, 60) + "\"";
        }
        result.add("underlyingAST=" + this.underlyingAST);
        result.add("treeLookup=" + AnalysisResult.treeLookupToString(this.treeLookup));
        result.add("convertedTreeLookup=" + AnalysisResult.treeLookupToString(this.convertedTreeLookup));
        result.add("postfixLookup=" + this.postfixNodeLookup);
        result.add("returnNodes=" + Node.nodeCollectionToString(this.returnNodes));
        result.add("declaredClasses=" + this.declaredClasses);
        result.add("declaredLambdas=" + this.declaredLambdas);
        result.add("}");
        return result.toString();
    }
}

