/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.expression;

import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.analysis.Store;
import org.checkerframework.nullaway.dataflow.expression.JavaExpression;
import org.checkerframework.nullaway.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.nullaway.javacutil.AnnotationProvider;

public class ArrayAccess
extends JavaExpression {
    protected final JavaExpression array;
    protected final JavaExpression index;

    public ArrayAccess(TypeMirror type, JavaExpression array, JavaExpression index) {
        super(type);
        this.array = array;
        this.index = index;
    }

    @Override
    public boolean containsOfClass(Class<? extends JavaExpression> clazz) {
        if (this.getClass() == clazz) {
            return true;
        }
        if (this.array.containsOfClass(clazz)) {
            return true;
        }
        return this.index.containsOfClass(clazz);
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return this.array.isDeterministic(provider) && this.index.isDeterministic(provider);
    }

    public JavaExpression getArray() {
        return this.array;
    }

    public JavaExpression getIndex() {
        return this.index;
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return false;
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return false;
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof ArrayAccess)) {
            return false;
        }
        ArrayAccess other = (ArrayAccess)je;
        return this.array.syntacticEquals(other.array) && this.index.syntacticEquals(other.index);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other) || this.array.containsSyntacticEqualJavaExpression(other) || this.index.containsSyntacticEqualJavaExpression(other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        if (this.array.containsModifiableAliasOf(store, other)) {
            return true;
        }
        return this.index.containsModifiableAliasOf(store, other);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ArrayAccess)) {
            return false;
        }
        ArrayAccess other = (ArrayAccess)obj;
        return this.array.equals(other.array) && this.index.equals(other.index);
    }

    public int hashCode() {
        return Objects.hash(this.array, this.index);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.array.toString());
        result.append("[");
        result.append(this.index.toString());
        result.append("]");
        return result.toString();
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitArrayAccess(this, p);
    }
}

