/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.listener.AnsiColorLogger;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.codehaus.groovy.ant.LoggingHelper;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.ErrorReporter;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;
import org.codehaus.groovy.tools.javac.JavaCompiler;
import org.codehaus.groovy.tools.javac.JavaCompilerFactory;

public class Groovyc
extends MatchingTask {
    private final LoggingHelper log = new LoggingHelper((Task)this);
    private Path src;
    private File destDir;
    private Path compileClasspath;
    private Path compileSourcepath;
    private String encoding;
    private boolean verbose = false;
    private boolean includeAntRuntime = true;
    private boolean includeJavaRuntime = false;
    private boolean fork = false;
    private String memoryInitialSize;
    private String memoryMaximumSize;
    protected boolean failOnError = true;
    protected boolean listFiles = false;
    protected File[] compileList = new File[0];
    private String updatedProperty;
    private String errorProperty;
    private boolean taskSuccess = true;
    private boolean includeDestClasses = true;
    protected CompilerConfiguration configuration = new CompilerConfiguration();
    private Javac javac;
    private boolean jointCompilation;

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setSourcepath(Path sourcepath) {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = sourcepath;
        } else {
            this.compileSourcepath.append(sourcepath);
        }
    }

    public Path getSourcepath() {
        return this.compileSourcepath;
    }

    public Path createSourcepath() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public void setSourcepathRef(Reference r) {
        this.createSourcepath().setRefid(r);
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setListfiles(boolean list) {
        this.listFiles = list;
    }

    public boolean getListfiles() {
        return this.listFiles;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setProceed(boolean proceed) {
        this.failOnError = !proceed;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setMemoryInitialSize(String memoryInitialSize) {
        this.memoryInitialSize = memoryInitialSize;
    }

    public String getMemoryInitialSize() {
        return this.memoryInitialSize;
    }

    public void setMemoryMaximumSize(String memoryMaximumSize) {
        this.memoryMaximumSize = memoryMaximumSize;
    }

    public String getMemoryMaximumSize() {
        return this.memoryMaximumSize;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setVerbose(boolean verbose) {
        this.configuration.setVerbose(verbose);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setFork(boolean f) {
        this.fork = f;
    }

    public void setUpdatedProperty(String updatedProperty) {
        this.updatedProperty = updatedProperty;
    }

    public void setErrorProperty(String errorProperty) {
        this.errorProperty = errorProperty;
    }

    public void setIncludeDestClasses(boolean includeDestClasses) {
        this.includeDestClasses = includeDestClasses;
    }

    public boolean isIncludeDestClasses() {
        return this.includeDestClasses;
    }

    public boolean getTaskSuccess() {
        return this.taskSuccess;
    }

    public void addConfiguredJavac(Javac javac) {
        this.javac = javac;
        this.jointCompilation = true;
    }

    public void setStacktrace(boolean stacktrace) {
        this.configuration.setDebug(stacktrace);
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        if (this.javac != null) {
            this.jointCompilation = true;
        }
        String[] list = this.src.list();
        for (int i = 0; i < list.length; ++i) {
            File srcDir = this.getProject().resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(srcDir, this.destDir != null ? this.destDir : srcDir, files);
        }
        this.compile();
        if (this.updatedProperty != null && this.taskSuccess && this.compileList.length != 0) {
            this.getProject().setNewProperty(this.updatedProperty, "true");
        }
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        m.setFrom("*.groovy");
        m.setTo("*.class");
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m);
        this.addToCompileList(newFiles);
        if (this.jointCompilation) {
            m.setFrom("*.java");
            m.setTo("*.class");
            newFiles = sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m);
            this.addToCompileList(newFiles);
        }
    }

    protected void addToCompileList(File[] newFiles) {
        if (newFiles.length > 0) {
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    public File[] getFileList() {
        return this.compileList;
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.getLocation());
        }
        if (this.encoding != null && !Charset.isSupported(this.encoding)) {
            throw new BuildException("encoding \"" + this.encoding + "\" not supported.");
        }
    }

    protected void compile() {
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            if (this.listFiles) {
                for (int i = 0; i < this.compileList.length; ++i) {
                    String filename = this.compileList[i].getAbsolutePath();
                    this.log(filename);
                }
            }
            if (this.fork) {
                Path classpath;
                String separator = System.getProperty("file.separator");
                Path path = classpath = this.getClasspath() != null ? this.getClasspath() : new Path(this.getProject());
                if (this.includeAntRuntime) {
                    classpath.addExisting(new Path(this.getProject()).concatSystemClasspath("last"));
                }
                if (this.includeJavaRuntime) {
                    classpath.addJavaRuntime();
                }
                ArrayList<String> commandLineList = new ArrayList<String>();
                commandLineList.add(System.getProperty("java.home") + separator + "bin" + separator + "java");
                commandLineList.add("-classpath");
                commandLineList.add(classpath.toString());
                if (this.memoryInitialSize != null && !this.memoryInitialSize.equals("")) {
                    commandLineList.add("-Xms" + this.memoryInitialSize);
                }
                if (this.memoryMaximumSize != null && !this.memoryMaximumSize.equals("")) {
                    commandLineList.add("-Xmx" + this.memoryMaximumSize);
                }
                commandLineList.add("org.codehaus.groovy.ant.Groovyc");
                commandLineList.add("--classpath");
                commandLineList.add(classpath.toString());
                if (this.jointCompilation) {
                    commandLineList.add("-j");
                    Iterator i = this.javac.getRuntimeConfigurableWrapper().getAttributeMap().entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        String key = e.getKey().toString();
                        if (key.indexOf("debug") != -1) {
                            commandLineList.add("-Fg");
                            continue;
                        }
                        if (key.indexOf("classpath") != -1) continue;
                        commandLineList.add("-J" + e.getKey() + "=" + e.getValue());
                    }
                }
                commandLineList.add(this.destDir.getPath());
                commandLineList.add(this.src.toString());
                String[] commandLine = new String[commandLineList.size()];
                for (int i = 0; i < commandLine.length; ++i) {
                    commandLine[i] = (String)commandLineList.get(i);
                }
                Execute executor = new Execute();
                executor.setAntRun(this.getProject());
                executor.setWorkingDirectory(this.getProject().getBaseDir());
                executor.setCommandline(commandLine);
                try {
                    executor.execute();
                }
                catch (IOException ioe) {
                    throw new BuildException("Error running forked groovyc.", (Throwable)ioe);
                }
                int returnCode = executor.getExitValue();
                if (returnCode != 0) {
                    throw new BuildException("Forked groovyc returned error code: " + returnCode);
                }
            } else {
                try {
                    Path classpath = this.getClasspath();
                    if (classpath != null) {
                        this.configuration.setClasspath(classpath.toString());
                    }
                    this.configuration.setTargetDirectory(this.destDir);
                    if (this.encoding != null) {
                        this.configuration.setSourceEncoding(this.encoding);
                    }
                    CompilationUnit unit = this.makeCompileUnit();
                    unit.addSources(this.compileList);
                    unit.compile();
                }
                catch (Exception e) {
                    StringWriter writer = new StringWriter();
                    new ErrorReporter(e, false).write(new PrintWriter(writer));
                    String message = writer.toString();
                    if (this.failOnError) {
                        throw new BuildException(message, (Throwable)e, this.getLocation());
                    }
                    this.log(message, 0);
                }
            }
        }
    }

    protected CompilationUnit makeCompileUnit() {
        if (this.javac != null) {
            HashMap<String, File> compilerOptions = new HashMap<String, File>();
            compilerOptions.put("stubDir", this.createTempDir());
            this.configuration.setJointCompilationOptions(compilerOptions);
            this.jointCompilation = true;
        }
        if (this.jointCompilation) {
            JavaAwareCompilationUnit unit = new JavaAwareCompilationUnit(this.configuration, this.buildClassLoaderFor());
            if (this.javac != null) {
                final JavaCompiler compiler = new JavaCompiler(){

                    public void compile(List files, CompilationUnit cu) {
                        if (Groovyc.this.javac.getClasspath() == null) {
                            Groovyc.this.javac.setClasspath(Groovyc.this.compileClasspath);
                        }
                        if (Groovyc.this.javac.getSourcepath() == null && Groovyc.this.compileSourcepath != null) {
                            Groovyc.this.javac.createSourcepath().add(Groovyc.this.compileSourcepath);
                        }
                        if (Groovyc.this.javac.getEncoding() == null) {
                            Groovyc.this.javac.setEncoding(Groovyc.this.encoding);
                        }
                        Groovyc.this.javac.setDestdir(Groovyc.this.destDir);
                        Path p = Groovyc.this.javac.createSrc();
                        p.add(Groovyc.this.src);
                        Path tmpDir = new Path(Groovyc.this.getProject());
                        File dir = (File)cu.getConfiguration().getJointCompilationOptions().get("stubDir");
                        tmpDir.setLocation(dir);
                        p.add(tmpDir);
                        Groovyc.this.javac.execute();
                    }
                };
                unit.setCompilerFactory(new JavaCompilerFactory(){

                    public JavaCompiler createCompiler(CompilerConfiguration config) {
                        return compiler;
                    }
                });
            }
            return unit;
        }
        return new CompilationUnit(this.configuration, null, this.buildClassLoaderFor());
    }

    protected File createTempDir() {
        File tempFile;
        try {
            tempFile = File.createTempFile("groovy-generated-", "-java-source");
            tempFile.delete();
            tempFile.mkdirs();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        return tempFile;
    }

    protected GroovyClassLoader buildClassLoaderFor() {
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        if (parent instanceof AntClassLoader) {
            AntClassLoader antLoader = (AntClassLoader)parent;
            String[] pathElm = antLoader.getClasspath().split(File.pathSeparator);
            List classpath = this.configuration.getClasspath();
            Iterator iter = classpath.iterator();
            while (iter.hasNext()) {
                String cpEntry = (String)iter.next();
                boolean found = false;
                for (int i = 0; i < pathElm.length; ++i) {
                    if (!cpEntry.equals(pathElm[i])) continue;
                    found = true;
                    break;
                }
                if (found || !new File(cpEntry).exists()) continue;
                antLoader.addPathElement(cpEntry);
            }
        }
        return new GroovyClassLoader(parent, this.configuration);
    }

    private String[] evalCompilerFlags(Project project, String[] args) {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"classpath");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Specify where to find the class files.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArgs((int)2);
        options.addOption(OptionBuilder.create((char)'J'));
        OptionBuilder.withArgName((String)"flag");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'F'));
        OptionBuilder.withLongOpt((String)"jointCompilation");
        options.addOption(OptionBuilder.create((char)'j'));
        PosixParser cliParser = new PosixParser();
        CommandLine cli = null;
        try {
            cli = cliParser.parse(options, args);
        }
        catch (ParseException e) {
            throw new BuildException((Throwable)e);
        }
        if (cli.hasOption("classpath")) {
            this.setClasspath(new Path(project, cli.getOptionValue("classpath")));
        }
        this.jointCompilation = cli.hasOption('j');
        if (this.jointCompilation) {
            HashMap<String, Object> compilerOptions = new HashMap<String, Object>();
            compilerOptions.put("namedValues", cli.getOptionValues('J'));
            compilerOptions.put("flags", cli.getOptionValues('F'));
            compilerOptions.put("stubDir", this.createTempDir());
            this.configuration.setJointCompilationOptions(compilerOptions);
        }
        return cli.getArgs();
    }

    public static void main(String[] args) {
        Project project = new Project();
        AnsiColorLogger logger = new AnsiColorLogger();
        logger.setMessageOutputLevel(2);
        project.addBuildListener((BuildListener)logger);
        project.init();
        Groovyc compiler = new Groovyc();
        compiler.setProject(project);
        String[] arguments = compiler.evalCompilerFlags(project, args);
        String dest = ".";
        String src = ".";
        boolean listFiles = false;
        if (arguments.length > 0) {
            dest = arguments[0];
        }
        if (arguments.length > 1) {
            src = arguments[1];
        }
        if (arguments.length > 2) {
            listFiles = arguments[2].equalsIgnoreCase("true");
        }
        compiler.setSrcdir(new Path(project, src));
        compiler.setDestdir(project.resolveFile(dest));
        compiler.setListfiles(listFiles);
        compiler.execute();
    }

    public void setStubdir(File stubDir) {
        this.jointCompilation = true;
        this.configuration.getJointCompilationOptions().put("stubDir", stubDir);
    }

    public File getStubdir() {
        return (File)this.configuration.getJointCompilationOptions().get("stubDir");
    }
}

