/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codehaus.groovy.antlr;

import antlr.LexerSharedInputState;

/**
 * GRECLIPSE-805 Support for unicode escape sequences
 * @author Andrew Eisenberg
 * @created Mar 3, 2011
 */
public class UnicodeLexerSharedInputState extends LexerSharedInputState {
    private final UnicodeEscapingReader escapingReader;

    private int prevUnescape;

    public UnicodeLexerSharedInputState(UnicodeEscapingReader in) {
        super(in);
        escapingReader = in; 
    }

    @Override
    public int getColumn() {
        prevUnescape = escapingReader.getUnescapedUnicodeColumnCount();
        return super.getColumn() + prevUnescape;
    }

    @Override
    public int getTokenStartColumn() {
        if (line == tokenStartLine) {
            return super.getTokenStartColumn() + escapingReader.getUnescapedUnicodeColumnCount();
        } else {
            return super.getTokenStartColumn() + prevUnescape;
        }
    }
}