/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.xbean.classloader.NonLockingJarFileClassLoader;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.runtime.m12n.ExtensionModuleScanner;
import org.codehaus.groovy.runtime.m12n.SimpleExtensionModule;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.ExternalJavaProject;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public final class GroovyClassLoaderFactory {
    private static Map<String, Map.Entry<IClasspathEntry[], GroovyClassLoader[]>> projectClassLoaderCache = new ConcurrentHashMap<String, Map.Entry<IClasspathEntry[], GroovyClassLoader[]>>();
    private GroovyClassLoader batchLoader;
    private final CompilerOptions compilerOptions;
    private final LookupEnvironment lookupEnvironment;
    private static final boolean NONLOCKING = Boolean.getBoolean("greclipse.nonlocking");

    static {
        if (NONLOCKING) {
            System.out.println("property set: greclipse.nonlocking: will try to avoid locking jars");
        }
    }

    public static void clearCache() {
        projectClassLoaderCache.clear();
    }

    public static void clearCache(String projectName) {
        Map.Entry<IClasspathEntry[], GroovyClassLoader[]> entry = projectClassLoaderCache.remove(projectName);
        if (entry != null) {
            Arrays.stream(entry.getValue()).filter(Objects::nonNull).forEach(GroovyClassLoaderFactory::close);
        }
    }

    private static void close(ClassLoader classLoader) {
        if (classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)classLoader)).close();
            }
            catch (IOException e) {
                Util.log(e);
            }
        }
        if (classLoader instanceof GroovyClassLoader) {
            ((GroovyClassLoader)classLoader).clearCache();
            GroovyClassLoaderFactory.close(classLoader.getParent());
        }
    }

    public GroovyClassLoaderFactory(CompilerOptions compilerOptions, Object requestor) {
        this.compilerOptions = compilerOptions;
        this.lookupEnvironment = requestor instanceof Compiler ? ((Compiler)requestor).lookupEnvironment : null;
    }

    public GroovyClassLoader[] getGroovyClassLoaders(CompilerConfiguration compilerConfiguration) {
        if (this.compilerOptions.groovyProjectName == null) {
            return this.getBatchGroovyClassLoaders(compilerConfiguration);
        }
        return this.getProjectGroovyClassLoaders(compilerConfiguration);
    }

    private GroovyClassLoader[] getBatchGroovyClassLoaders(CompilerConfiguration compilerConfiguration) {
        if (this.batchLoader == null && this.lookupEnvironment != null) {
            try {
                FileSystem.Classpath[] classpaths;
                INameEnvironment nameEnvironment = this.lookupEnvironment.nameEnvironment;
                if (nameEnvironment.getClass().getName().endsWith("tests.compiler.regression.InMemoryNameEnvironment")) {
                    nameEnvironment = ((INameEnvironment[])ReflectionUtils.getPrivateField(nameEnvironment.getClass(), "classLibs", nameEnvironment))[0];
                }
                if (nameEnvironment instanceof FileSystem && (classpaths = (FileSystem.Classpath[])ReflectionUtils.getPrivateField(FileSystem.class, "classpaths", nameEnvironment)) != null) {
                    this.batchLoader = new GroovyClassLoader();
                    FileSystem.Classpath[] classpathArray = classpaths;
                    int n = classpaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileSystem.Classpath classpath = classpathArray[n2];
                        this.batchLoader.addClasspath(classpath.getPath());
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                Util.log(e, "Unexpected problem computing classpath for batch compiler");
            }
        }
        return new GroovyClassLoader[]{new GrapeAwareGroovyClassLoader(this.batchLoader, compilerConfiguration), this.batchLoader};
    }

    private GroovyClassLoader[] getProjectGroovyClassLoaders(CompilerConfiguration compilerConfiguration) {
        String projectName = this.compilerOptions.groovyProjectName;
        IProject project = GroovyClassLoaderFactory.findProject(projectName);
        try {
            IJavaProject javaProject = " ".equals(projectName) ? new ExternalJavaProject(JavaCore.create(project).getRawClasspath()) : JavaCore.create(project);
            Object[] classpathEntries = javaProject.exists() ? javaProject.getResolvedClasspath(true) : ClasspathEntry.NO_ENTRIES;
            Map.Entry entry = projectClassLoaderCache.computeIfAbsent(projectName, arg_0 -> this.lambda$2(javaProject, (IClasspathEntry[])classpathEntries, project, compilerConfiguration, arg_0));
            if (Arrays.equals(classpathEntries, (Object[])entry.getKey())) {
                return (GroovyClassLoader[])entry.getValue();
            }
            projectClassLoaderCache.remove(projectName);
            return this.getProjectGroovyClassLoaders(compilerConfiguration);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to bootstrap GroovyClassLoaders for project '" + projectName + "'", e);
        }
    }

    private static IProject findProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    private static void calculateClasspath(IJavaProject javaProject, Set<String> classPaths, Set<String> xformPaths) {
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject);
            Arrays.sort(entries, Comparator.comparing(IRuntimeClasspathEntry::getType));
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeClasspathEntry unresolved = iRuntimeClasspathEntryArray[n2];
                Set<String> paths = unresolved.getType() == 4 ? classPaths : xformPaths;
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = GroovyClassLoaderFactory.resolveRuntimeClasspathEntry(unresolved);
                int n3 = iRuntimeClasspathEntryArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IRuntimeClasspathEntry resolved = iRuntimeClasspathEntryArray2[n4];
                    paths.add(GroovyClassLoaderFactory.getAbsoluteLocation(resolved));
                    ++n4;
                }
                ++n2;
            }
            classPaths.addAll(xformPaths);
            assert (classPaths.stream().map(File::new).allMatch(File::isAbsolute));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry classpathEntry) throws ReflectiveOperationException {
        return (IRuntimeClasspathEntry[])JavaRuntime.class.getDeclaredMethod("resolveRuntimeClasspathEntry", IRuntimeClasspathEntry.class, IJavaProject.class).invoke(JavaRuntime.class, classpathEntry, classpathEntry.getJavaProject());
    }

    private static String getAbsoluteLocation(IRuntimeClasspathEntry classpathEntry) {
        String location;
        if (classpathEntry.getType() == 1) {
            try {
                ((IJavaProject)JavaCore.create(classpathEntry.getResource())).getOutputLocation();
            }
            catch (NullPointerException | JavaModelException ignore) {
                return classpathEntry.getResource().getLocation().toOSString();
            }
        }
        if (!new File(location = classpathEntry.getLocation()).exists()) {
            IProject resource;
            Path path = new Path(location);
            IProject project = GroovyClassLoaderFactory.findProject(path.segment(0));
            IResource iResource = resource = path.segmentCount() == 1 ? project : project.getFile(path.removeFirstSegments(1));
            if (resource.getLocation() != null) {
                location = resource.getLocation().toOSString();
            }
        }
        return location;
    }

    private static URLClassLoader newClassLoader(Set<String> classpath, ClassLoader parent) {
        URL[] urls = (URL[])classpath.stream().map(file -> {
            try {
                return new File((String)file).toURI().toURL();
            }
            catch (MalformedURLException ignore) {
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
        if (NONLOCKING) {
            if (parent == null) {
                parent = URLClassLoader.newInstance(new URL[0], null);
            }
            return new NonLockingJarFileClassLoader("GDT non-locking loader", urls, parent);
        }
        return URLClassLoader.newInstance(urls, parent);
    }

    private /* synthetic */ Map.Entry lambda$2(IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray, IProject iProject, CompilerConfiguration compilerConfiguration, String key) {
        LinkedHashSet<String> classPaths = new LinkedHashSet<String>();
        LinkedHashSet<String> xformPaths = new LinkedHashSet<String>();
        if (iJavaProject.exists()) {
            GroovyClassLoaderFactory.calculateClasspath(iJavaProject, classPaths, xformPaths);
        }
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.AST_TRANSFORM, "Transform classpath: " + String.join((CharSequence)File.pathSeparator, xformPaths));
        }
        ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader();
        return new AbstractMap.SimpleEntry<IClasspathEntry[], GroovyClassLoader[]>(iClasspathEntryArray, new GroovyClassLoader[]{new GrapeAwareGroovyClassLoader(iProject, (ClassLoader)GroovyClassLoaderFactory.newClassLoader(classPaths, parentClassLoader), compilerConfiguration), new EclipseGroovyClassLoader(iProject, (ClassLoader)GroovyClassLoaderFactory.newClassLoader(xformPaths, this.getClass().getClassLoader()))});
    }

    private static class EclipseGroovyClassLoader
    extends GroovyClassLoader {
        private final IProject project;

        private EclipseGroovyClassLoader(IProject project, ClassLoader parent) {
            this(project, parent, CompilerConfiguration.DEFAULT);
        }

        private EclipseGroovyClassLoader(IProject project, ClassLoader parent, CompilerConfiguration config) {
            super(parent, config, false);
            this.project = project;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> resources = super.getResources(name);
            if (this.project != null && resources.hasMoreElements() && (name.startsWith("META-INF/groovy/") || name.startsWith("META-INF/services/"))) {
                String exclude = this.project.getLocation().toOSString();
                if (!exclude.startsWith("/")) {
                    try {
                        exclude = new File(exclude).toURI().toURL().getPath();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ArrayList<URL> list = new ArrayList<URL>();
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    if (resource.getProtocol().equals("file") && resource.getPath().startsWith(exclude)) continue;
                    list.add(resource);
                }
                resources = Collections.enumeration(list);
            }
            return resources;
        }
    }

    public static class GrapeAwareGroovyClassLoader
    extends EclipseGroovyClassLoader {
        public boolean grabbed;
        private volatile Set<Class> defaultCategories;
        private volatile Set<Class> defaultStaticCategories;

        public GrapeAwareGroovyClassLoader(ClassLoader parent, CompilerConfiguration config) {
            super(null, parent, config);
        }

        private GrapeAwareGroovyClassLoader(IProject project, ClassLoader parent, CompilerConfiguration config) {
            super(project, parent, config);
        }

        @Override
        public void addURL(URL url) {
            this.grabbed = true;
            super.addURL(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Class> getDefaultCategories() {
            if (this.defaultCategories == null) {
                GrapeAwareGroovyClassLoader grapeAwareGroovyClassLoader = this;
                synchronized (grapeAwareGroovyClassLoader) {
                    block7: {
                        if (this.defaultCategories == null) {
                            LinkedHashSet<Class> objectCategories = new LinkedHashSet<Class>();
                            LinkedHashSet<Class> staticCategories = new LinkedHashSet<Class>();
                            try {
                                Class dgm2 = this.loadClass("org.codehaus.groovy.runtime.DefaultGroovyMethods", false, true);
                                Class dgsm = this.loadClass("org.codehaus.groovy.runtime.DefaultGroovyStaticMethods", false, true);
                                Collections.addAll(objectCategories, (Class[])dgm2.getField("DGM_LIKE_CLASSES").get(dgm2));
                                Collections.addAll(objectCategories, (Class[])dgm2.getField("ADDITIONAL_CLASSES").get(dgm2));
                                Class vmpf = this.loadClass("org.codehaus.groovy.vmplugin.VMPluginFactory", false, true);
                                Object vmp = vmpf.getMethod("getPlugin", new Class[0]).invoke((Object)vmpf, new Object[0]);
                                Collections.addAll(objectCategories, (Class[])vmp.getClass().getMethod("getPluginDefaultGroovyMethods", new Class[0]).invoke(vmp, new Object[0]));
                                Collections.addAll(staticCategories, (Class[])vmp.getClass().getMethod("getPluginStaticGroovyMethods", new Class[0]).invoke(vmp, new Object[0]));
                                new ExtensionModuleScanner(module -> {
                                    if (module instanceof SimpleExtensionModule) {
                                        objectCategories.addAll(((SimpleExtensionModule)module).getInstanceMethodsExtensionClasses());
                                        staticCategories.addAll(((SimpleExtensionModule)module).getStaticMethodsExtensionClasses());
                                    }
                                }, this).scanClasspathModules();
                                staticCategories.add(dgsm);
                                objectCategories.addAll(staticCategories);
                                this.defaultCategories = objectCategories;
                                this.defaultStaticCategories = staticCategories;
                            }
                            catch (LinkageError | ReflectiveOperationException e) {
                                this.defaultCategories = Collections.EMPTY_SET;
                                this.defaultStaticCategories = Collections.EMPTY_SET;
                                if (!GroovyLogManager.manager.hasLoggers()) break block7;
                                GroovyLogManager.manager.log(TraceCategory.CLASSPATH, "Failed to find Default Groovy Methods with " + this + "\n\t" + e.getMessage());
                            }
                        }
                    }
                }
            }
            return Collections.unmodifiableSet(this.defaultCategories);
        }

        public boolean isDefaultStaticCategory(String name) {
            if (this.defaultStaticCategories == null) {
                this.getDefaultCategories();
            }
            return this.defaultStaticCategories.stream().map(Class::getName).anyMatch(name::equals);
        }
    }
}

