/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.util.Hashtable;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<IExtensionRegistry, IExtensionRegistry> {
    private static Activator singleton;
    private static BundleContext bundleContext;
    private ServiceRegistration<IContentTypeManager> contentManagerService;
    private ServiceTracker<DebugOptions, Object> debugTracker;
    private ServiceTracker<IExtensionRegistry, IExtensionRegistry> registryTracker;

    public static Activator getDefault() {
        return singleton;
    }

    @Override
    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        singleton = this;
        this.contentManagerService = bundleContext.registerService(IContentTypeManager.class, ContentTypeManager.getInstance(), new Hashtable());
        this.registryTracker = new ServiceTracker<IExtensionRegistry, IExtensionRegistry>(context, IExtensionRegistry.class, this);
        this.registryTracker.open();
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        if (this.contentManagerService != null) {
            this.contentManagerService.unregister();
            this.contentManagerService = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.registryTracker != null) {
            this.registryTracker.close();
            this.registryTracker = null;
        }
        ContentTypeManager.shutdown();
        bundleContext = null;
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        DebugOptions options;
        if (this.debugTracker == null) {
            this.debugTracker = new ServiceTracker(bundleContext, DebugOptions.class, null);
            this.debugTracker.open();
        }
        if ((options = (DebugOptions)this.debugTracker.getService()) != null && (value = options.getOption(option)) != null) {
            return "true".equalsIgnoreCase(value);
        }
        return defaultValue;
    }

    @Override
    public IExtensionRegistry addingService(ServiceReference<IExtensionRegistry> reference) {
        IExtensionRegistry registry = bundleContext.getService(reference);
        ContentTypeManager.addRegistryChangeListener(registry);
        return registry;
    }

    @Override
    public void modifiedService(ServiceReference<IExtensionRegistry> reference, IExtensionRegistry service) {
    }

    @Override
    public void removedService(ServiceReference<IExtensionRegistry> reference, IExtensionRegistry service) {
        ContentTypeManager.removeRegistryChangeListener(service);
        bundleContext.ungetService(reference);
    }
}

