/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.http;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import uk.co.wilson.net.MinMLSocketServer;
import uk.co.wilson.net.MinMLThreadPool;
import uk.co.wilson.net.http.MinMLHTTPServer;

public class HTTPServer
extends GroovyObjectSupport {
    protected static final byte[] userAgent = "User-Agent: Groovy Simple Web Server\r\n".getBytes();
    private final int minWorkers;
    private final int maxWorkers;
    private final int maxKeepAlives;
    private final int workerIdleLife;
    private final int socketReadTimeout;
    private MinMLSocketServer server = null;
    private Closure getClosure = null;
    private Closure headClosure = null;
    private Closure postClosure = null;
    private Closure putClosure = null;

    public HTTPServer(int n, int n2, int n3, int n4, int n5) {
        this.minWorkers = n;
        this.maxWorkers = n2;
        this.maxKeepAlives = n3;
        this.workerIdleLife = n4;
        this.socketReadTimeout = n5;
    }

    public HTTPServer() {
        this(2, 10, 8, 60000, 60000);
    }

    public void setProperty(String string, Object object) {
        if ("get".equalsIgnoreCase(string) && object instanceof Closure) {
            this.getClosure = (Closure)((Closure)object).clone();
        } else if ("head".equalsIgnoreCase(string) && object instanceof Closure) {
            this.headClosure = (Closure)((Closure)object).clone();
        } else if ("post".equalsIgnoreCase(string) && object instanceof Closure) {
            this.postClosure = (Closure)((Closure)object).clone();
        } else if ("put".equalsIgnoreCase(string) && object instanceof Closure) {
            this.putClosure = (Closure)((Closure)object).clone();
        } else {
            super.setProperty(string, object);
        }
    }

    public void startServer(ServerSocket serverSocket) throws IOException {
        if (this.server != null) {
            this.stopServer();
        }
        final MinMLHTTPServer minMLHTTPServer = new MinMLHTTPServer(serverSocket, this.minWorkers, this.maxWorkers, this.maxKeepAlives, this.workerIdleLife, this.socketReadTimeout){

            protected MinMLThreadPool.Worker makeNewWorker() {
                return new MinMLHTTPServer.HTTPWorker(){

                    protected void processGet(InputStream inputStream, OutputStream outputStream, String string, String string2) throws Exception {
                        outputStream.write(string2.getBytes());
                        outputStream.write(okMessage);
                        outputStream.write(userAgent);
                        outputStream.write(host);
                        if (HTTPServer.this.getClosure != null) {
                            HTTPServer.this.getClosure.call(new Object[]{inputStream, outputStream, string, string2});
                        }
                    }

                    protected void processHead(InputStream inputStream, OutputStream outputStream, String string, String string2) throws Exception {
                        outputStream.write(string2.getBytes());
                        outputStream.write(okMessage);
                        outputStream.write(userAgent);
                        outputStream.write(host);
                        if (HTTPServer.this.headClosure != null) {
                            HTTPServer.this.headClosure.call(new Object[]{inputStream, outputStream, string, string2});
                        }
                    }

                    protected void processPost(InputStream inputStream, OutputStream outputStream, String string, String string2) throws Exception {
                        outputStream.write(string2.getBytes());
                        outputStream.write(okMessage);
                        outputStream.write(userAgent);
                        outputStream.write(host);
                        if (HTTPServer.this.postClosure != null) {
                            HTTPServer.this.postClosure.call(new Object[]{inputStream, outputStream, string, string2});
                        }
                    }

                    protected void processPut(InputStream inputStream, OutputStream outputStream, String string, String string2) throws Exception {
                        outputStream.write(string2.getBytes());
                        outputStream.write(okMessage);
                        outputStream.write(userAgent);
                        outputStream.write(host);
                        if (HTTPServer.this.putClosure != null) {
                            HTTPServer.this.putClosure.call(new Object[]{inputStream, outputStream, string, string2});
                        }
                    }
                };
            }
        };
        this.server = minMLHTTPServer;
        Thread thread = new Thread(){

            public void run() {
                minMLHTTPServer.start();
            }
        };
        thread.setDaemon(false);
        thread.setName("HTTP Server main thread");
        thread.start();
    }

    public void stopServer() throws IOException {
        this.server.shutDown();
    }
}

